/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.util;

import java.util.Arrays;
import java.util.Date;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.module.extension.ExtendedPersonalInfo;
import org.mule.module.extension.HeisenbergExtension;
import org.mule.module.extension.LifetimeInfo;
import org.mule.module.extension.internal.capability.metadata.ParameterGroupCapability;
import org.mule.module.extension.internal.introspection.ParameterGroup;
import org.mule.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.module.extension.internal.util.GroupValueSetter;
import org.mule.module.extension.internal.util.IntrospectionUtils;
import org.mule.module.extension.internal.util.ValueSetter;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class GroupValueSetterTestCase
extends AbstractMuleTestCase {
    private static final String NAME = "name";
    private static final Integer AGE = 50;
    private static final Date DATE = new Date();
    private ValueSetter valueSetter;
    @Mock
    private ResolverSetResult result;

    @Before
    public void before() throws Exception {
        ParameterGroup group = new ParameterGroup(ExtendedPersonalInfo.class, IntrospectionUtils.getField(HeisenbergExtension.class, (String)"personalInfo", ExtendedPersonalInfo.class));
        group.addParameter("myName", IntrospectionUtils.getField(ExtendedPersonalInfo.class, (String)NAME, String.class));
        group.addParameter("age", IntrospectionUtils.getField(ExtendedPersonalInfo.class, (String)"age", Integer.class));
        ParameterGroup child = new ParameterGroup(LifetimeInfo.class, IntrospectionUtils.getField(ExtendedPersonalInfo.class, (String)"lifetimeInfo", LifetimeInfo.class));
        child.addParameter("dateOfBirth", IntrospectionUtils.getField(LifetimeInfo.class, (String)"dateOfBirth", Date.class));
        group.addCapability((Object)new ParameterGroupCapability(Arrays.asList(child)));
        Mockito.when((Object)this.result.get("myName")).thenReturn((Object)NAME);
        Mockito.when((Object)this.result.get("age")).thenReturn((Object)AGE);
        Mockito.when((Object)this.result.get("dateOfBirth")).thenReturn((Object)DATE);
        this.valueSetter = new GroupValueSetter(group);
    }

    @Test
    public void set() throws Exception {
        HeisenbergExtension extension = new HeisenbergExtension();
        this.valueSetter.set((Object)extension, this.result);
        Assert.assertThat((Object)extension.getPersonalInfo().getName(), (Matcher)CoreMatchers.is((Object)NAME));
        Assert.assertThat((Object)extension.getPersonalInfo().getAge(), (Matcher)CoreMatchers.is((Object)AGE));
        Assert.assertThat((Object)extension.getPersonalInfo().getLifetimeInfo().getDateOfBirth(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)DATE)));
    }
}

