/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.util;

import org.apache.commons.lang.ArrayUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.mockito.Answers;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.registry.MuleRegistry;
import org.mule.extension.introspection.DataType;
import org.mule.extension.introspection.Extension;
import org.mule.extension.introspection.Operation;
import org.mule.extension.introspection.Parameter;
import org.mule.extension.runtime.ConfigurationInstanceProvider;
import org.mule.extension.runtime.OperationContext;
import org.mule.module.extension.internal.manager.ExtensionManagerAdapter;
import org.mule.module.extension.internal.runtime.DefaultOperationContext;
import org.mule.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.module.extension.internal.runtime.resolver.ValueResolver;

public abstract class ExtensionsTestUtils {
    public static final String HELLO_WORLD = "Hello World!";

    public static ValueResolver getResolver(Object value) throws Exception {
        return ExtensionsTestUtils.getResolver(value, null, true, new Class[0]);
    }

    public static ValueResolver getResolver(Object value, MuleEvent event, boolean dynamic, Class<?> ... extraInterfaces) throws Exception {
        ValueResolver resolver = ArrayUtils.isEmpty((Object[])extraInterfaces) ? (ValueResolver)Mockito.mock(ValueResolver.class) : (ValueResolver)Mockito.mock(ValueResolver.class, (MockSettings)Mockito.withSettings().extraInterfaces((Class[])extraInterfaces));
        Mockito.when((Object)resolver.resolve(event != null ? (MuleEvent)Matchers.same((Object)event) : (MuleEvent)Matchers.any(MuleEvent.class))).thenReturn(value);
        Mockito.when((Object)resolver.isDynamic()).thenReturn((Object)dynamic);
        return resolver;
    }

    public static Parameter getParameter(String name, Class<?> type) {
        Parameter parameter = (Parameter)Mockito.mock(Parameter.class);
        Mockito.when((Object)parameter.getName()).thenReturn((Object)name);
        Mockito.when((Object)parameter.getType()).thenReturn((Object)DataType.of(type));
        return parameter;
    }

    public static void stubRegistryKeys(MuleContext muleContext, final String ... keys) {
        Mockito.when((Object)muleContext.getRegistry().get(Matchers.anyString())).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                String name = (String)invocation.getArguments()[0];
                if (name != null) {
                    for (String key : keys) {
                        if (!name.contains(key)) continue;
                        return null;
                    }
                }
                return Answers.RETURNS_DEEP_STUBS.get().answer(invocation);
            }
        });
    }

    public static void assertRegisteredWithUniqueMadeKey(MuleContext muleContext, String key, Object object) throws Exception {
        ArgumentCaptor captor = ArgumentCaptor.forClass(String.class);
        ((MuleRegistry)Mockito.verify((Object)muleContext.getRegistry())).registerObject((String)captor.capture(), Matchers.same((Object)object));
        Assert.assertThat((Object)captor.getValue(), (Matcher)CoreMatchers.containsString((String)key));
    }

    public static <C> C getConfigurationInstanceFromExtensionManager(String key, Extension extension, MuleEvent muleEvent) throws Exception {
        return (C)ExtensionsTestUtils.extractExtensionManager(muleEvent).getConfigurationInstance(extension, key, ExtensionsTestUtils.getOperationContext(muleEvent));
    }

    public static <C> C getConfigurationInstanceFromRegistry(String key, MuleEvent muleEvent) throws Exception {
        ConfigurationInstanceProvider configurationInstanceProvider = (ConfigurationInstanceProvider)muleEvent.getMuleContext().getRegistry().get(key);
        return (C)configurationInstanceProvider.get(ExtensionsTestUtils.getOperationContext(muleEvent));
    }

    private static ExtensionManagerAdapter extractExtensionManager(MuleEvent muleEvent) {
        return (ExtensionManagerAdapter)muleEvent.getMuleContext().getExtensionManager();
    }

    private static OperationContext getOperationContext(MuleEvent event) throws Exception {
        return new DefaultOperationContext((Extension)Mockito.mock(Extension.class), (Operation)Mockito.mock(Operation.class), "", (ResolverSetResult)Mockito.mock(ResolverSetResult.class), event, ExtensionsTestUtils.extractExtensionManager(event));
    }
}

