/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime.resolver;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.DefaultMuleContext;
import org.mule.api.MuleEvent;
import org.mule.expression.DefaultExpressionManager;
import org.mule.extension.introspection.DataType;
import org.mule.module.extension.internal.runtime.resolver.TypeSafeExpressionValueResolver;
import org.mule.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class TypeSafeExpressionValueResolverTestCase
extends AbstractMuleContextTestCase {
    private static final String HELLO_WORLD = "Hello World!";
    private DefaultExpressionManager expressionManager;

    protected void doSetUp() throws Exception {
        this.expressionManager = (DefaultExpressionManager)Mockito.spy((Object)((DefaultExpressionManager)muleContext.getExpressionManager()));
        DefaultMuleContext defaultMuleContext = (DefaultMuleContext)muleContext;
        defaultMuleContext.setExpressionManager(this.expressionManager);
    }

    @Test
    public void expressionLanguageWithoutTransformation() throws Exception {
        this.assertResolved(this.getResolver("#['Hello ' + payload]", String.class).resolve(TypeSafeExpressionValueResolverTestCase.getTestEvent((Object)"World!")), HELLO_WORLD, Mockito.never());
    }

    @Test
    public void expressionTemplateWithoutTransformation() throws Exception {
        this.assertResolved(this.getResolver("Hello #[payload]", String.class).resolve(TypeSafeExpressionValueResolverTestCase.getTestEvent((Object)"World!")), HELLO_WORLD, Mockito.times((int)1));
    }

    @Test
    public void constant() throws Exception {
        this.assertResolved(this.getResolver(HELLO_WORLD, String.class).resolve(TypeSafeExpressionValueResolverTestCase.getTestEvent((Object)HELLO_WORLD)), HELLO_WORLD, Mockito.never());
    }

    @Test
    public void expressionWithTransformation() throws Exception {
        this.assertResolved(this.getResolver("#[true]", String.class).resolve(TypeSafeExpressionValueResolverTestCase.getTestEvent((Object)HELLO_WORLD)), "true", Mockito.never());
    }

    @Test
    public void templateWithTransformation() throws Exception {
        this.assertResolved(this.getResolver("tru#['e']", String.class).resolve(TypeSafeExpressionValueResolverTestCase.getTestEvent((Object)HELLO_WORLD)), "true", Mockito.times((int)1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void nullExpression() throws Exception {
        this.getResolver(null, String.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void blankExpression() throws Exception {
        this.getResolver("", String.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void nullExpectedType() throws Exception {
        this.getResolver("#[payload]", null);
    }

    private void assertResolved(Object resolvedValue, Object expected, VerificationMode expressionManagerVerificationMode) {
        Assert.assertThat((Object)resolvedValue, (Matcher)IsInstanceOf.instanceOf(String.class));
        Assert.assertThat((Object)resolvedValue, (Matcher)CoreMatchers.equalTo((Object)expected));
        this.verifyExpressionManager(expressionManagerVerificationMode);
    }

    private void verifyExpressionManager(VerificationMode mode) {
        ((DefaultExpressionManager)Mockito.verify((Object)this.expressionManager, (VerificationMode)mode)).parse(Matchers.anyString(), (MuleEvent)Matchers.any(MuleEvent.class));
    }

    private ValueResolver getResolver(String expression, Class<?> expectedType) throws Exception {
        return new TypeSafeExpressionValueResolver(expression, DataType.of(expectedType));
    }
}

