/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime.resolver;

import java.util.LinkedHashMap;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.extension.introspection.Parameter;
import org.mule.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ResolverSetTestCase
extends AbstractMuleTestCase {
    private static final String NAME = "MG";
    private static final int AGE = 31;
    private ResolverSet set;
    private Map<Parameter, ValueResolver> mapping;
    @Mock
    private MuleEvent event;
    @Mock
    private MuleContext muleContext;

    @Before
    public void before() throws Exception {
        this.mapping = new LinkedHashMap<Parameter, ValueResolver>();
        this.mapping.put(ExtensionsTestUtils.getParameter("myName", String.class), this.getResolver(NAME));
        this.mapping.put(ExtensionsTestUtils.getParameter("age", Integer.class), this.getResolver(31));
        this.set = this.buildSet(this.mapping);
    }

    @Test
    public void resolve() throws Exception {
        ResolverSetResult result = this.set.resolve(this.event);
        this.assertResult(result, this.mapping);
    }

    @Test(expected=IllegalArgumentException.class)
    public void addNullParameter() throws Exception {
        this.set.add(null, this.getResolver(null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void addNullresolver() throws Exception {
        this.set.add(ExtensionsTestUtils.getParameter("blah", String.class), null);
    }

    @Test(expected=IllegalStateException.class)
    public void addRepeatedParameter() throws Exception {
        Parameter parameter = ExtensionsTestUtils.getParameter("name", String.class);
        ValueResolver resolver = this.getResolver(NAME);
        this.set.add(parameter, resolver);
        this.set.add(parameter, resolver);
    }

    @Test
    public void isNotDynamic() {
        Assert.assertThat((Object)this.set.isDynamic(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void isDynamic() throws Exception {
        ValueResolver resolver = this.getResolver(null);
        Mockito.when((Object)resolver.isDynamic()).thenReturn((Object)true);
        this.set.add(ExtensionsTestUtils.getParameter("whatever", String.class), resolver);
        Assert.assertThat((Object)this.set.isDynamic(), (Matcher)CoreMatchers.is((Object)true));
    }

    private void assertResult(ResolverSetResult result, Map<Parameter, ValueResolver> mapping) throws Exception {
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        for (Map.Entry<Parameter, ValueResolver> entry : mapping.entrySet()) {
            Object value = result.get(entry.getKey());
            Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)entry.getValue().resolve(this.event)));
        }
    }

    private ResolverSet buildSet(Map<Parameter, ValueResolver> mapping) {
        ResolverSet set = new ResolverSet();
        for (Map.Entry<Parameter, ValueResolver> entry : mapping.entrySet()) {
            set.add(entry.getKey(), entry.getValue());
        }
        return set;
    }

    private ValueResolver getResolver(Object value) throws Exception {
        return ExtensionsTestUtils.getResolver(value, this.event, false, MuleContextAware.class, Lifecycle.class);
    }
}

