/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime.resolver;

import java.util.NoSuchElementException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.extension.introspection.Parameter;
import org.mule.module.extension.HealthStatus;
import org.mule.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class ResolverSetResultTestCase
extends AbstractMuleTestCase {
    private static final String NAME = "MG";
    private static final int AGE = 31;
    private static final HealthStatus HEALTH = null;
    private Parameter nameParameter;
    private Parameter ageParameter;
    private Parameter healthParameter;
    private ResolverSetResult result;

    @Before
    public void before() throws Exception {
        this.nameParameter = ExtensionsTestUtils.getParameter("myName", String.class);
        this.ageParameter = ExtensionsTestUtils.getParameter("age", Integer.class);
        this.healthParameter = ExtensionsTestUtils.getParameter("initialHealth", HealthStatus.class);
        this.result = this.buildResult();
    }

    @Test
    public void testValues() {
        this.assertResult(this.result);
    }

    @Test
    public void equals() {
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.equalTo((Object)this.buildResult()));
    }

    @Test
    public void notEquals() {
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)this.agelessResult())));
    }

    @Test
    public void equivalentHashCode() {
        Assert.assertThat((Object)this.result.hashCode(), (Matcher)CoreMatchers.equalTo((Object)this.buildResult().hashCode()));
    }

    @Test
    public void nonEquivalentHashCode() {
        Assert.assertThat((Object)this.result.hashCode(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)this.agelessResult().hashCode())));
    }

    @Test(expected=IllegalArgumentException.class)
    public void nullParameter() {
        this.getBuilder().add(null, (Object)"blah");
    }

    @Test(expected=NoSuchElementException.class)
    public void invalidParameter() {
        this.result.get(ExtensionsTestUtils.getParameter("invalid", String.class));
    }

    private void assertResult(ResolverSetResult result) {
        Assert.assertThat((Object)((String)result.get(this.nameParameter)), (Matcher)Is.is((Object)NAME));
        Assert.assertThat((Object)((Integer)result.get(this.ageParameter)), (Matcher)Is.is((Object)31));
        Assert.assertThat((Object)((Object)((HealthStatus)((Object)result.get(this.healthParameter)))), (Matcher)Is.is((Object)((Object)HEALTH)));
    }

    private ResolverSetResult buildResult() {
        return this.getBuilder().build();
    }

    private ResolverSetResult agelessResult() {
        return this.getBuilder().add(this.ageParameter, null).build();
    }

    private ResolverSetResult.Builder getBuilder() {
        return ResolverSetResult.newBuilder().add(this.nameParameter, (Object)NAME).add(this.ageParameter, (Object)31).add(this.healthParameter, (Object)HEALTH);
    }
}

