/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime.resolver;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.api.MuleEvent;
import org.mule.api.registry.MuleRegistry;
import org.mule.module.extension.internal.runtime.resolver.RegistryLookupValueResolver;
import org.mule.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class RegistryLookupValueResolverTestCase
extends AbstractMuleTestCase {
    private static final String KEY = "key";
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleEvent event;
    private ValueResolver resolver;

    @Before
    public void before() throws Exception {
        Mockito.when((Object)this.event.getMuleContext().getRegistry().get(KEY)).thenReturn((Object)"Hello World!");
        this.resolver = new RegistryLookupValueResolver(KEY);
    }

    @Test
    public void cache() throws Exception {
        Object value = this.resolver.resolve(this.event);
        Assert.assertThat((Object)((String)value), (Matcher)CoreMatchers.is((Object)"Hello World!"));
        ((MuleRegistry)Mockito.verify((Object)this.event.getMuleContext().getRegistry())).get(KEY);
    }

    @Test
    public void isDynamic() {
        Assert.assertThat((Object)this.resolver.isDynamic(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test(expected=IllegalArgumentException.class)
    public void nullKey() {
        new RegistryLookupValueResolver(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void blankKey() {
        new RegistryLookupValueResolver("");
    }
}

