/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime.resolver;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.NestedProcessor;
import org.mule.api.processor.MessageProcessor;
import org.mule.module.extension.internal.runtime.resolver.NestedProcessorValueResolver;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

@RunWith(value=MockitoJUnitRunner.class)
public class NestedProcessorValueResolverTestCase
extends AbstractMuleContextTestCase {
    private static final String RESPONSE = "Hello world!";
    @Mock
    private MuleContext muleContext;
    @Mock
    private MessageProcessor messageProcessor;

    @Before
    public void before() throws Exception {
        Mockito.when((Object)this.messageProcessor.process((MuleEvent)Matchers.any(MuleEvent.class))).thenReturn((Object)NestedProcessorValueResolverTestCase.getTestEvent((Object)RESPONSE));
    }

    @Test
    public void yieldsNestedProcessor() throws Exception {
        MuleEvent muleEvent = NestedProcessorValueResolverTestCase.getTestEvent((Object)"");
        NestedProcessorValueResolver resolver = new NestedProcessorValueResolver(this.messageProcessor);
        NestedProcessor nestedProcessor = resolver.resolve(muleEvent);
        Object response = nestedProcessor.process();
        Assert.assertThat((Object)((String)response), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)RESPONSE)));
        ArgumentCaptor captor = ArgumentCaptor.forClass(MuleEvent.class);
        ((MessageProcessor)Mockito.verify((Object)this.messageProcessor)).process((MuleEvent)captor.capture());
        MuleEvent capturedEvent = (MuleEvent)captor.getValue();
        Assert.assertThat((Object)capturedEvent.getId(), (Matcher)CoreMatchers.is((Object)muleEvent.getId()));
    }

    @Test
    public void alwaysGivesDifferentInstances() throws Exception {
        MuleEvent muleEvent = NestedProcessorValueResolverTestCase.getTestEvent((Object)"");
        NestedProcessorValueResolver resolver = new NestedProcessorValueResolver(this.messageProcessor);
        NestedProcessor resolved1 = resolver.resolve(muleEvent);
        NestedProcessor resolved2 = resolver.resolve(muleEvent);
        Assert.assertThat((Object)resolved1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)resolved2))));
    }
}

