/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime.resolver;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.extension.ExtensionManager;
import org.mule.extension.runtime.OperationContext;
import org.mule.module.extension.HeisenbergExtension;
import org.mule.module.extension.internal.runtime.ConfigurationObjectBuilder;
import org.mule.module.extension.internal.runtime.DynamicConfigurationInstanceProvider;
import org.mule.module.extension.internal.runtime.resolver.AbstractConfigurationInstanceProviderTestCase;
import org.mule.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class DynamicConfigurationInstanceProviderTestCase
extends AbstractConfigurationInstanceProviderTestCase {
    private static final Class MODULE_CLASS = HeisenbergExtension.class;
    @Mock
    private ResolverSet resolverSet;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ResolverSetResult resolverSetResult;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleContext muleContext;
    @Mock
    private MuleEvent event;
    @Mock
    private ExtensionManager extensionManager;
    private ConfigurationObjectBuilder configurationObjectBuilder;

    @Before
    public void before() throws Exception {
        ExtensionsTestUtils.stubRegistryKeys(this.muleContext, "config");
        Mockito.when((Object)this.configuration.getInstantiator().getObjectType()).thenReturn((Object)MODULE_CLASS);
        Mockito.when((Object)this.configuration.getInstantiator().newInstance()).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                return MODULE_CLASS.newInstance();
            }
        });
        Mockito.when((Object)this.configuration.getCapabilities((Class)Mockito.any(Class.class))).thenReturn(null);
        Mockito.when((Object)this.resolverSet.resolve(this.event)).thenReturn((Object)this.resolverSetResult);
        Mockito.when((Object)this.muleContext.getExtensionManager()).thenReturn((Object)this.extensionManager);
        Mockito.when((Object)this.operationContext.getEvent()).thenReturn((Object)this.event);
        this.configurationObjectBuilder = new ConfigurationObjectBuilder("config", this.extension, this.configuration, this.resolverSet, this.configurationInstanceRegistrationCallback);
        this.instanceProvider = new DynamicConfigurationInstanceProvider(this.configurationObjectBuilder, this.resolverSet);
    }

    @Test
    public void resolveCached() throws Exception {
        int count = 10;
        HeisenbergExtension config = (HeisenbergExtension)this.instanceProvider.get((OperationContext)this.operationContext);
        for (int i = 1; i < 10; ++i) {
            Assert.assertThat((Object)((HeisenbergExtension)this.instanceProvider.get((OperationContext)this.operationContext)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)config)));
        }
        ((ResolverSet)Mockito.verify((Object)this.resolverSet, (VerificationMode)Mockito.times((int)10))).resolve(this.event);
    }

    @Test
    public void resolveDifferentInstances() throws Exception {
        HeisenbergExtension instance1 = (HeisenbergExtension)this.instanceProvider.get((OperationContext)this.operationContext);
        ResolverSetResult alternateResult = (ResolverSetResult)Mockito.mock(ResolverSetResult.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.resolverSet.resolve(this.event)).thenReturn((Object)alternateResult);
        HeisenbergExtension instance2 = (HeisenbergExtension)this.instanceProvider.get((OperationContext)this.operationContext);
        Assert.assertThat((Object)instance2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)instance1))));
    }

    @Test
    public void resolveDynamicConfigWithEquivalentEvent() throws Exception {
        this.assertSameInstancesResolved();
        this.assertConfigInstanceRegistered(this.instanceProvider.get((OperationContext)this.operationContext));
    }

    @Test
    public void resolveDynamicConfigWithDifferentEvent() throws Exception {
        Object config1 = this.instanceProvider.get((OperationContext)this.operationContext);
        Mockito.when((Object)this.resolverSet.resolve(this.event)).thenReturn(Mockito.mock(ResolverSetResult.class));
        Object config2 = this.instanceProvider.get((OperationContext)this.operationContext);
        Assert.assertThat((Object)config1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)Matchers.sameInstance((Object)config2))));
        this.assertConfigInstanceRegistered(config1);
        this.assertConfigInstanceRegistered(config2);
    }
}

