/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime.resolver;

import java.util.HashMap;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.extension.introspection.Configuration;
import org.mule.extension.introspection.Extension;
import org.mule.extension.introspection.Parameter;
import org.mule.extension.runtime.ConfigurationInstanceRegistrationCallback;
import org.mule.module.extension.HeisenbergExtension;
import org.mule.module.extension.internal.manager.ExtensionManagerAdapter;
import org.mule.module.extension.internal.runtime.resolver.AbstractConfigurationInstanceProviderTestCase;
import org.mule.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.module.extension.internal.util.MuleExtensionUtils;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ConfigurationInstanceProviderTestCase
extends AbstractConfigurationInstanceProviderTestCase {
    private static final Class MODULE_CLASS = HeisenbergExtension.class;
    private static final String MY_NAME = "heisenberg";
    private static final int AGE = 50;
    @Mock
    private ResolverSet resolverSet;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleContext muleContext;
    @Mock
    private MuleEvent event;
    @Mock
    private ResolverSetResult resolverSetResult;
    @Mock
    private ExtensionManagerAdapter extensionManager;

    @Before
    public void before() throws Exception {
        Mockito.when((Object)this.muleContext.getExtensionManager()).thenReturn((Object)this.extensionManager);
        ExtensionsTestUtils.stubRegistryKeys(this.muleContext, "config");
        Mockito.when((Object)this.configuration.getInstantiator().getObjectType()).thenReturn((Object)MODULE_CLASS);
        Mockito.when((Object)this.configuration.getInstantiator().newInstance()).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                return MODULE_CLASS.newInstance();
            }
        });
        Mockito.when((Object)this.configuration.getCapabilities((Class)Mockito.any(Class.class))).thenReturn(null);
        Mockito.when((Object)this.operationContext.getEvent()).thenReturn((Object)this.event);
        HashMap<Parameter, StaticValueResolver> parameters = new HashMap<Parameter, StaticValueResolver>();
        parameters.put(ExtensionsTestUtils.getParameter("myName", String.class), new StaticValueResolver((Object)MY_NAME));
        parameters.put(ExtensionsTestUtils.getParameter("age", Integer.class), new StaticValueResolver((Object)50));
        Mockito.when((Object)this.resolverSet.getResolvers()).thenReturn(parameters);
        Mockito.when((Object)this.resolverSet.isDynamic()).thenReturn((Object)false);
        this.instanceProvider = MuleExtensionUtils.createConfigurationInstanceProvider((String)"config", (Extension)this.extension, (Configuration)this.configuration, (ResolverSet)this.resolverSet, (MuleContext)this.muleContext, (ConfigurationInstanceRegistrationCallback)this.extensionManager);
    }

    @Test
    public void resolveStaticConfig() throws Exception {
        this.assertSameInstancesResolved();
    }
}

