/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.module.extension.internal.runtime.resolver.CollectionValueResolver;
import org.mule.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;

@RunWith(value=Parameterized.class)
public class CollectionValueResolverTestCase
extends AbstractMuleTestCase {
    private Class<? extends Collection> collectionType;
    private CollectionValueResolver resolver;
    private List<ValueResolver> childResolvers;
    private List<Integer> expectedValues;
    private MuleContext muleContext;
    private MuleEvent event;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({ArrayList.class}, {HashSet.class});
    }

    public CollectionValueResolverTestCase(Class<? extends Collection> collectionType) {
        this.collectionType = collectionType;
    }

    @Before
    public void before() throws Exception {
        this.muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        this.event = (MuleEvent)Mockito.mock(MuleEvent.class);
        this.collectionType = ArrayList.class;
        this.childResolvers = new ArrayList<ValueResolver>();
        this.expectedValues = new ArrayList<Integer>();
        for (int i = 0; i < this.getChildResolversCount(); ++i) {
            ValueResolver childResolver = ExtensionsTestUtils.getResolver(i, this.event, false, MuleContextAware.class, Lifecycle.class);
            this.childResolvers.add(childResolver);
            this.expectedValues.add(i);
        }
        this.resolver = this.createCollectionResolver(this.childResolvers);
    }

    @Test
    public void resolve() throws Exception {
        Collection resolved = this.resolver.resolve(this.event);
        Assert.assertThat((Object)resolved, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)resolved.size(), (Matcher)CoreMatchers.equalTo((Object)this.getChildResolversCount()));
        Assert.assertThat((Object)resolved, (Matcher)CoreMatchers.hasItems((Object[])this.expectedValues.toArray()));
    }

    @Test
    public void resolversAreCopied() throws Exception {
        int initialResolversCount = this.childResolvers.size();
        this.childResolvers.add(ExtensionsTestUtils.getResolver(-1, this.event, false, new Class[0]));
        Collection resolved = this.resolver.resolve(this.event);
        Assert.assertThat((Object)resolved.size(), (Matcher)CoreMatchers.equalTo((Object)initialResolversCount));
    }

    @Test
    public void emptyList() throws Exception {
        this.childResolvers.clear();
        this.resolver = this.createCollectionResolver(this.childResolvers);
        Collection resolved = this.resolver.resolve((MuleEvent)Mockito.mock(MuleEvent.class));
        Assert.assertThat((Object)resolved, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)resolved.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void isNotDynamic() {
        Assert.assertThat((Object)this.resolver.isDynamic(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void isDynamic() throws Exception {
        this.childResolvers = new ArrayList<ValueResolver>();
        this.childResolvers.add(ExtensionsTestUtils.getResolver(null, this.event, false, new Class[0]));
        this.childResolvers.add(ExtensionsTestUtils.getResolver(null, this.event, true, new Class[0]));
        this.resolver = this.createCollectionResolver(this.childResolvers);
        Assert.assertThat((Object)this.resolver.isDynamic(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void collectionOfExpectedType() throws Exception {
        Collection resolved = this.resolver.resolve((MuleEvent)Mockito.mock(MuleEvent.class));
        Assert.assertThat((Object)resolved, (Matcher)CoreMatchers.instanceOf(this.collectionType));
    }

    @Test
    public void resolvedCollectionIsMutalbe() throws Exception {
        Collection resolved = this.resolver.resolve((MuleEvent)Mockito.mock(MuleEvent.class));
        int originalSize = resolved.size();
        resolved.add(-1);
        Assert.assertThat((Object)resolved.size(), (Matcher)CoreMatchers.equalTo((Object)(originalSize + 1)));
    }

    protected int getChildResolversCount() {
        return 10;
    }

    private CollectionValueResolver createCollectionResolver(List<ValueResolver> childResolvers) {
        return new CollectionValueResolver(this.collectionType, childResolvers);
    }

    protected void doAssertOf(Class<? extends Collection> collectionType, Class<? extends ValueResolver> expectedResolverType) {
        CollectionValueResolver resolver = new CollectionValueResolver(((Collection)Mockito.mock(collectionType)).getClass(), new ArrayList());
        Assert.assertThat((Object)(resolver.getClass() == expectedResolverType ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
    }
}

