/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime.processor;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.extension.introspection.Extension;
import org.mule.extension.introspection.Operation;
import org.mule.extension.runtime.OperationContext;
import org.mule.extension.runtime.OperationExecutor;
import org.mule.module.extension.internal.manager.ExtensionManagerAdapter;
import org.mule.module.extension.internal.runtime.OperationContextAdapter;
import org.mule.module.extension.internal.runtime.processor.OperationMessageProcessor;
import org.mule.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class OperationMessageProcessorTestCase
extends AbstractMuleTestCase {
    private static final String CONFIG_NAME = "config";
    @Mock
    private Extension extension;
    @Mock
    private Operation operation;
    @Mock
    private ExtensionManagerAdapter extensionManager;
    @Mock(extraInterfaces={Lifecycle.class, MuleContextAware.class})
    private OperationExecutor operationExecutor;
    @Mock
    private MuleContext muleContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ResolverSet resolverSet;
    @Mock
    private ResolverSetResult parameters;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleEvent event;
    @Mock
    private Object configurationInstance;
    private OperationMessageProcessor messageProcessor;
    private String configurationInstanceName = "config";

    @Before
    public void before() throws Exception {
        Mockito.when((Object)this.operation.getExecutor()).thenReturn((Object)this.operationExecutor);
        Mockito.when((Object)this.resolverSet.resolve(this.event)).thenReturn((Object)this.parameters);
        Mockito.when((Object)this.extensionManager.getConfigurationInstance((Extension)Matchers.same((Object)this.extension), (String)Matchers.same((Object)this.configurationInstanceName), (OperationContext)Matchers.any(OperationContext.class))).thenReturn(this.configurationInstance);
        this.messageProcessor = this.createOperationMessageProcessor();
    }

    @Test
    public void operationExecutorIsInvoked() throws Exception {
        this.messageProcessor.process(this.event);
        ((OperationExecutor)Mockito.verify((Object)this.operationExecutor)).execute((OperationContext)Matchers.any(OperationContext.class));
    }

    @Test
    public void operationContextIsWellFormed() throws Exception {
        ArgumentCaptor operationContextCaptor = ArgumentCaptor.forClass(OperationContext.class);
        this.messageProcessor.process(this.event);
        ((OperationExecutor)Mockito.verify((Object)this.operationExecutor)).execute((OperationContext)operationContextCaptor.capture());
        OperationContext operationContext = (OperationContext)operationContextCaptor.getValue();
        Assert.assertThat((Object)operationContext, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(OperationContextAdapter.class)));
        OperationContextAdapter operationContextAdapter = (OperationContextAdapter)operationContext;
        Assert.assertThat((Object)operationContextAdapter.getEvent(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.event)));
        Assert.assertThat((Object)operationContextAdapter.getOperation(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.operation)));
        Assert.assertThat((Object)operationContextAdapter.getConfigurationInstance(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.configurationInstance)));
    }

    @Test
    public void operationReturnsMuleEvent() throws Exception {
        MuleEvent responseEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
        Mockito.when((Object)this.operationExecutor.execute((OperationContext)Matchers.any(OperationContext.class))).thenReturn((Object)responseEvent);
        Assert.assertThat((Object)this.messageProcessor.process(this.event), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)responseEvent)));
    }

    @Test
    public void operationReturnsMuleMessage() throws Exception {
        MuleMessage responseMessage = (MuleMessage)Mockito.mock(MuleMessage.class);
        Mockito.when((Object)this.operationExecutor.execute((OperationContext)Matchers.any(OperationContext.class))).thenReturn((Object)responseMessage);
        Assert.assertThat((Object)this.messageProcessor.process(this.event), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.event)));
        ((MuleEvent)Mockito.verify((Object)this.event)).setMessage(responseMessage);
    }

    @Test
    public void operationReturnsPayloadValue() throws Exception {
        Object value = new Object();
        Mockito.when((Object)this.operationExecutor.execute((OperationContext)Matchers.any(OperationContext.class))).thenReturn(value);
        Assert.assertThat((Object)this.messageProcessor.process(this.event), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.event)));
        ((MuleMessage)Mockito.verify((Object)this.event.getMessage())).setPayload(value);
    }

    @Test
    public void executesWithDefaultConfig() throws Exception {
        this.configurationInstanceName = null;
        this.messageProcessor = this.createOperationMessageProcessor();
        Object defaultConfigInstance = new Object();
        Mockito.when((Object)this.extensionManager.getConfigurationInstance((Extension)Matchers.same((Object)this.extension), (OperationContext)Matchers.any(OperationContext.class))).thenReturn(defaultConfigInstance);
        ArgumentCaptor operationContextCaptor = ArgumentCaptor.forClass(OperationContext.class);
        this.messageProcessor.process(this.event);
        ((OperationExecutor)Mockito.verify((Object)this.operationExecutor)).execute((OperationContext)operationContextCaptor.capture());
        OperationContext operationContext = (OperationContext)operationContextCaptor.getValue();
        Assert.assertThat((Object)operationContext, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(OperationContextAdapter.class)));
        Assert.assertThat((Object)operationContext.getConfigurationInstance(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)defaultConfigInstance)));
    }

    @Test
    public void initialise() throws Exception {
        ((MuleContextAware)Mockito.verify((Object)((MuleContextAware)this.operationExecutor))).setMuleContext(this.muleContext);
        ((Initialisable)Mockito.verify((Object)((Initialisable)this.operationExecutor))).initialise();
    }

    @Test
    public void start() throws Exception {
        this.messageProcessor.start();
        ((Startable)Mockito.verify((Object)((Startable)this.operationExecutor))).start();
    }

    @Test
    public void stop() throws Exception {
        this.messageProcessor.stop();
        ((Stoppable)Mockito.verify((Object)((Stoppable)this.operationExecutor))).stop();
    }

    @Test
    public void dispose() throws Exception {
        this.messageProcessor.dispose();
        ((Disposable)Mockito.verify((Object)((Disposable)this.operationExecutor))).dispose();
    }

    private OperationMessageProcessor createOperationMessageProcessor() throws Exception {
        OperationMessageProcessor messageProcessor = new OperationMessageProcessor(this.extension, this.operation, this.configurationInstanceName, this.resolverSet, this.extensionManager);
        messageProcessor.setMuleContext(this.muleContext);
        messageProcessor.initialise();
        return messageProcessor;
    }
}

