/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.api.MuleEvent;
import org.mule.extension.introspection.Extension;
import org.mule.extension.introspection.Operation;
import org.mule.extension.introspection.Parameter;
import org.mule.extension.runtime.OperationContext;
import org.mule.module.extension.HealthStatus;
import org.mule.module.extension.HeisenbergExtension;
import org.mule.module.extension.HeisenbergOperations;
import org.mule.module.extension.internal.manager.ExtensionManagerAdapter;
import org.mule.module.extension.internal.runtime.DefaultOperationContext;
import org.mule.module.extension.internal.runtime.ReflectiveMethodOperationExecutor;
import org.mule.module.extension.internal.runtime.ValueReturnDelegate;
import org.mule.module.extension.internal.runtime.VoidReturnDelegate;
import org.mule.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.util.ClassUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ReflectiveMethodOperationExecutorTestCase
extends AbstractMuleTestCase {
    private static final String CONFIG_NAME = "config";
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleEvent muleEvent;
    @Mock
    private ResolverSetResult parameters;
    @Mock
    private Extension extension;
    @Mock
    private Operation operation;
    @Mock
    private ExtensionManagerAdapter extensionManager;
    private ReflectiveMethodOperationExecutor executor;
    private OperationContext operationContext;
    private HeisenbergExtension config;
    private HeisenbergOperations operations;

    @Before
    public void init() {
        this.initHeisenberg();
        this.operationContext = new DefaultOperationContext(this.extension, this.operation, CONFIG_NAME, this.parameters, this.muleEvent, this.extensionManager);
        Mockito.when((Object)this.extensionManager.getConfigurationInstance(this.extension, CONFIG_NAME, this.operationContext)).thenReturn((Object)this.config);
    }

    @Test
    public void operationWithReturnValueAndWithoutParameters() throws Exception {
        Method method = ClassUtils.getMethod(HeisenbergOperations.class, (String)"sayMyName", (Class[])new Class[]{HeisenbergExtension.class});
        this.executor = new ReflectiveMethodOperationExecutor(method, (Object)this.operations, ValueReturnDelegate.INSTANCE);
        this.assertResult(this.executor.execute(this.operationContext), "Heisenberg");
    }

    @Test
    public void voidOperationWithoutParameters() throws Exception {
        Method method = ClassUtils.getMethod(HeisenbergOperations.class, (String)"die", (Class[])new Class[]{HeisenbergExtension.class});
        this.executor = new ReflectiveMethodOperationExecutor(method, (Object)this.operations, VoidReturnDelegate.INSTANCE);
        this.assertSameInstance(this.executor.execute(this.operationContext), this.muleEvent);
        Assert.assertThat((Object)((Object)this.config.getEndingHealth()), (Matcher)CoreMatchers.is((Object)((Object)HealthStatus.DEAD)));
    }

    @Test
    public void withArgumentsAndReturnValue() throws Exception {
        HashMap<Parameter, Integer> parametersMap = new HashMap<Parameter, Integer>();
        parametersMap.put(ExtensionsTestUtils.getParameter("index", Integer.TYPE), 0);
        Mockito.when((Object)this.parameters.asMap()).thenReturn(parametersMap);
        this.init();
        Method method = ClassUtils.getMethod(HeisenbergOperations.class, (String)"getEnemy", (Class[])new Class[]{HeisenbergExtension.class, Integer.TYPE});
        this.executor = new ReflectiveMethodOperationExecutor(method, (Object)this.operations, ValueReturnDelegate.INSTANCE);
        this.assertResult(this.executor.execute(this.operationContext), "Hank");
    }

    @Test
    public void voidWithArguments() throws Exception {
        Method method = ClassUtils.getMethod(HeisenbergOperations.class, (String)"hideMethInEvent", (Class[])new Class[]{MuleEvent.class});
        this.executor = new ReflectiveMethodOperationExecutor(method, (Object)this.operations, VoidReturnDelegate.INSTANCE);
        this.assertSameInstance(this.executor.execute(this.operationContext), this.muleEvent);
        ((MuleEvent)Mockito.verify((Object)this.muleEvent)).setFlowVariable("secretPackage", (Object)"meth");
    }

    private void initHeisenberg() {
        this.config = new HeisenbergExtension();
        this.config.getPersonalInfo().setName("Heisenberg");
        this.config.setEnemies(Arrays.asList("Hank"));
        this.operations = new HeisenbergOperations();
    }

    private void assertResult(Object value, Object expected) throws Exception {
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)expected));
    }

    private void assertSameInstance(Object value, Object expected) throws Exception {
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)expected)));
    }
}

