/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.module.extension.ExtendedPersonalInfo;
import org.mule.module.extension.LifetimeInfo;
import org.mule.module.extension.internal.runtime.DefaultObjectBuilder;
import org.mule.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.module.extension.internal.util.IntrospectionUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class DefaultObjectBuilderTestCase
extends AbstractMuleTestCase {
    private static Class<?> PROTOTYPE_CLASS = ExtendedPersonalInfo.class;
    private static final String NAME = "heisenberg";
    private static final int AGE = 50;
    private static LifetimeInfo LIFETIME_INFO = new LifetimeInfo();
    @Mock
    private MuleEvent event;
    @Mock
    private MuleContext muleContext;
    private DefaultObjectBuilder<ExtendedPersonalInfo> builder;
    private Field nameField;
    private Field ageField;
    private Field lifetimeInfoField;
    private List<ValueResolver> resolvers = new ArrayList<ValueResolver>();

    @Before
    public void before() {
        this.builder = new DefaultObjectBuilder(PROTOTYPE_CLASS);
        this.nameField = IntrospectionUtils.getField(PROTOTYPE_CLASS, (String)"name", String.class);
        this.ageField = IntrospectionUtils.getField(PROTOTYPE_CLASS, (String)"age", Integer.class);
        this.lifetimeInfoField = IntrospectionUtils.getField(PROTOTYPE_CLASS, (String)"lifetimeInfo", LifetimeInfo.class);
    }

    @Test
    public void build() throws Exception {
        this.populate(false);
        ExtendedPersonalInfo personalInfo = (ExtendedPersonalInfo)this.builder.build(this.event);
        this.verify(personalInfo);
    }

    @Test
    public void reusable() throws Exception {
        this.populate(false);
        ExtendedPersonalInfo info1 = (ExtendedPersonalInfo)this.builder.build(this.event);
        ExtendedPersonalInfo info2 = (ExtendedPersonalInfo)this.builder.build(this.event);
        ExtendedPersonalInfo info3 = (ExtendedPersonalInfo)this.builder.build(this.event);
        Assert.assertThat((Object)info1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)info2)));
        Assert.assertThat((Object)info1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)info3)));
        this.verify(info1);
        this.verify(info2);
        this.verify(info3);
    }

    private void verify(ExtendedPersonalInfo personalInfo) {
        Assert.assertThat((Object)personalInfo.getName(), (Matcher)CoreMatchers.is((Object)NAME));
        Assert.assertThat((Object)personalInfo.getAge(), (Matcher)CoreMatchers.is((Object)50));
        Assert.assertThat((Object)personalInfo.getLifetimeInfo(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)LIFETIME_INFO)));
    }

    @Test
    public void isStatic() throws Exception {
        this.populate(false);
        Assert.assertThat((Object)this.builder.isDynamic(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void isDynamic() throws Exception {
        this.builder.addPropertyResolver(this.nameField, this.getResolver(NAME, false));
        this.builder.addPropertyResolver(this.ageField, this.getResolver(50, true));
        Assert.assertThat((Object)this.builder.isDynamic(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test(expected=IllegalArgumentException.class)
    public void buildInterface() throws Exception {
        this.builder = new DefaultObjectBuilder(MuleMessage.class);
        this.builder.build(this.event);
    }

    @Test(expected=IllegalArgumentException.class)
    public void abstractClass() throws Exception {
        this.builder = new DefaultObjectBuilder(TestAbstract.class);
        this.builder.build(this.event);
    }

    @Test(expected=IllegalArgumentException.class)
    public void noDefaultConstructor() throws Exception {
        this.builder = new DefaultObjectBuilder(TestNoDefaultConstructor.class);
        this.builder.build(this.event);
    }

    @Test(expected=IllegalArgumentException.class)
    public void noPublicConstructor() throws Exception {
        this.builder = new DefaultObjectBuilder(NoPublicConstructor.class);
        this.builder.build(this.event);
    }

    private void populate(boolean dynamic) throws Exception {
        this.builder.addPropertyResolver(this.nameField, this.getResolver(NAME, dynamic));
        this.builder.addPropertyResolver(this.ageField, this.getResolver(50, dynamic));
        this.builder.addPropertyResolver(this.lifetimeInfoField, this.getResolver(LIFETIME_INFO, dynamic));
    }

    private ValueResolver getResolver(Object value, boolean dynamic) throws Exception {
        ValueResolver resolver = ExtensionsTestUtils.getResolver(value, this.event, dynamic, new Class[0]);
        this.resolvers.add(resolver);
        return resolver;
    }

    public static class NoPublicConstructor {
        protected NoPublicConstructor() {
        }
    }

    public static class TestNoDefaultConstructor {
        public TestNoDefaultConstructor(String value) {
        }
    }

    private static abstract class TestAbstract {
        private TestAbstract() {
        }
    }
}

