/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime;

import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleEvent;
import org.mule.extension.introspection.Configuration;
import org.mule.extension.introspection.Extension;
import org.mule.extension.introspection.Parameter;
import org.mule.extension.runtime.ConfigurationInstanceRegistrationCallback;
import org.mule.module.extension.internal.capability.metadata.ParameterGroupCapability;
import org.mule.module.extension.internal.runtime.ConfigurationObjectBuilder;
import org.mule.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ConfigurationObjectBuilderTestCase
extends AbstractMuleTestCase {
    private static final String CONFIG_NAME = "configName";
    private static final String NAME_VALUE = "name";
    private static final String DESCRIPTION_VALUE = "description";
    @Mock
    private Extension extension;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Configuration configuration;
    @Mock
    private ConfigurationInstanceRegistrationCallback registrationCallback;
    @Mock
    private MuleEvent event;
    private TestConfig configurationInstance;
    private ConfigurationObjectBuilder configurationObjectBuilder;
    private ResolverSet resolverSet;
    private Parameter nameParameter = ExtensionsTestUtils.getParameter("name", String.class);
    private Parameter descriptionParameter = ExtensionsTestUtils.getParameter("description", String.class);

    @Before
    public void before() throws Exception {
        this.configurationInstance = new TestConfig();
        Mockito.when((Object)this.configuration.getParameters()).thenReturn(Arrays.asList(this.nameParameter, this.descriptionParameter));
        Mockito.when((Object)this.configuration.getInstantiator().newInstance()).thenReturn((Object)this.configurationInstance);
        Mockito.when((Object)this.configuration.getInstantiator().getObjectType()).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                return TestConfig.class;
            }
        });
        Mockito.when((Object)this.configuration.getCapabilities(ParameterGroupCapability.class)).thenReturn(null);
        this.resolverSet = new ResolverSet();
        this.resolverSet.add(this.nameParameter, ExtensionsTestUtils.getResolver(NAME_VALUE));
        this.resolverSet.add(this.descriptionParameter, ExtensionsTestUtils.getResolver(DESCRIPTION_VALUE));
        this.configurationObjectBuilder = new ConfigurationObjectBuilder(CONFIG_NAME, this.extension, this.configuration, this.resolverSet, this.registrationCallback);
    }

    @Test
    public void build() throws Exception {
        TestConfig testConfig = (TestConfig)this.configurationObjectBuilder.build(this.event);
        Assert.assertThat((Object)testConfig.getName(), (Matcher)CoreMatchers.is((Object)NAME_VALUE));
        Assert.assertThat((Object)testConfig.getDescription(), (Matcher)CoreMatchers.is((Object)DESCRIPTION_VALUE));
    }

    @Test
    public void registerOnBuild() throws Exception {
        this.configurationObjectBuilder.build(this.event);
        ((ConfigurationInstanceRegistrationCallback)Mockito.verify((Object)this.registrationCallback)).registerConfigurationInstance(this.extension, CONFIG_NAME, (Object)this.configurationInstance);
    }

    public static class TestConfig {
        private String name;
        private String description;

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

