/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.resources;

import java.util.Arrays;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.api.registry.ServiceRegistry;
import org.mule.extension.introspection.Extension;
import org.mule.extension.resources.GeneratedResource;
import org.mule.extension.resources.ResourcesGenerator;
import org.mule.extension.resources.spi.GenerableResourceContributor;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public abstract class ResourcesGeneratorContractTestCase
extends AbstractMuleTestCase {
    protected ResourcesGenerator generator;
    protected ServiceRegistry serviceRegistry;

    @Before
    public void before() {
        this.serviceRegistry = (ServiceRegistry)Mockito.mock(ServiceRegistry.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.generator = this.buildGenerator();
    }

    protected abstract ResourcesGenerator buildGenerator();

    @Test
    public void getOrCreateResource() {
        String filepath = "path";
        GeneratedResource resource = this.generator.get("path");
        Assert.assertNotNull((Object)resource);
        Assert.assertEquals((String)"path", (String)resource.getFilePath());
        Assert.assertNotNull((Object)resource.getContentBuilder());
        Assert.assertSame((Object)resource, (Object)this.generator.get("path"));
    }

    @Test
    public void generate() {
        GenerableResourceContributor contributor = (GenerableResourceContributor)Mockito.mock(GenerableResourceContributor.class);
        Mockito.when((Object)this.serviceRegistry.lookupProviders((Class)Matchers.same(GenerableResourceContributor.class), (ClassLoader)Matchers.any(ClassLoader.class))).thenReturn(Arrays.asList(contributor));
        Extension extension = (Extension)Mockito.mock(Extension.class);
        this.generator.generateFor(extension);
        ((GenerableResourceContributor)Mockito.verify((Object)contributor)).contribute(extension, this.generator);
    }
}

