/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.manager;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.api.registry.ServiceRegistry;
import org.mule.extension.ExtensionManager;
import org.mule.extension.introspection.Extension;
import org.mule.extension.introspection.ExtensionFactory;
import org.mule.extension.introspection.declaration.Describer;
import org.mule.extension.introspection.declaration.fluent.Descriptor;
import org.mule.module.extension.internal.introspection.ExtensionDiscoverer;
import org.mule.module.extension.internal.manager.DefaultExtensionDiscoverer;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ExtensionDiscovererTestCase
extends AbstractMuleTestCase {
    @Mock
    private ExtensionManager extensionManager;
    @Mock
    private ExtensionFactory extensionFactory;
    @Mock
    private ServiceRegistry serviceRegistry;
    @Mock
    private Descriptor descriptor;
    @Mock
    private Describer describer;
    @Mock
    private Extension extension;
    private ExtensionDiscoverer discoverer;

    @Before
    public void setUp() {
        this.discoverer = new DefaultExtensionDiscoverer(this.extensionFactory, this.serviceRegistry);
    }

    @Test
    public void scan() throws Exception {
        Mockito.when((Object)this.serviceRegistry.lookupProviders(Describer.class, ((Object)((Object)this)).getClass().getClassLoader())).thenReturn(Arrays.asList(this.describer));
        Mockito.when((Object)this.describer.describe()).thenReturn((Object)this.descriptor);
        Mockito.when((Object)this.extensionFactory.createFrom(this.descriptor)).thenReturn((Object)this.extension);
        List extensions = this.discoverer.discover(((Object)((Object)this)).getClass().getClassLoader());
        Assert.assertThat((Object)extensions, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(extensions.get(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.extension)));
        ((ServiceRegistry)Mockito.verify((Object)this.serviceRegistry)).lookupProviders(Describer.class, ((Object)((Object)this)).getClass().getClassLoader());
        ((Describer)Mockito.verify((Object)this.describer)).describe();
        ((ExtensionFactory)Mockito.verify((Object)this.extensionFactory)).createFrom(this.descriptor);
    }

    @Test(expected=IllegalArgumentException.class)
    public void nullClassLoader() {
        this.discoverer.discover(null);
    }
}

