/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.manager;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleContext;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.extension.introspection.Configuration;
import org.mule.extension.introspection.Extension;
import org.mule.extension.introspection.Operation;
import org.mule.extension.introspection.Parameter;
import org.mule.extension.introspection.capability.XmlCapability;
import org.mule.extension.runtime.ConfigurationInstanceProvider;
import org.mule.extension.runtime.OperationContext;
import org.mule.extension.runtime.OperationExecutor;
import org.mule.module.extension.internal.capability.metadata.ParameterGroupCapability;
import org.mule.module.extension.internal.introspection.ExtensionDiscoverer;
import org.mule.module.extension.internal.manager.DefaultExtensionManager;
import org.mule.module.extension.internal.manager.ExtensionManagerAdapter;
import org.mule.module.extension.internal.runtime.OperationContextAdapter;
import org.mule.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.util.concurrent.Latch;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class DefaultExtensionManagerTestCase
extends AbstractMuleTestCase {
    private ExtensionManagerAdapter extensionsManager;
    private static final String EXTENSION1_NAME = "extension1";
    private static final String EXTENSION1_CONFIG_NAME = "extension1Config";
    private static final String EXTENSION1_CONFIG_INSTANCE_NAME = "extension1ConfigInstanceName";
    private static final String EXTENSION1_OPERATION_NAME = "extension1OperationName";
    private static final String EXTENSION2_NAME = "extension2";
    private static final String EXTENSION1_VERSION = "3.6.0";
    private static final String EXTENSION2_VERSION = "3.6.0";
    private static final String NEWER_VERSION = "4.0";
    private static final String OLDER_VERSION = "3.5.1";
    @Mock
    private ExtensionDiscoverer discoverer;
    @Mock
    private Extension extension1;
    @Mock
    private Extension extension2;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleContext muleContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Configuration extension1Configuration;
    @Mock
    private Operation extension1Operation;
    @Mock
    private OperationContextAdapter extension1OperationContext;
    @Mock
    private ConfigurationInstanceProvider<Object> extension1ConfigurationInstanceProvider;
    @Mock
    private OperationExecutor executor;
    private ClassLoader classLoader;
    private final Object configInstance = new Object();

    @Before
    public void before() throws InitialisationException {
        DefaultExtensionManager extensionsManager = new DefaultExtensionManager();
        extensionsManager.setExtensionsDiscoverer(this.discoverer);
        extensionsManager.setMuleContext(this.muleContext);
        extensionsManager.initialise();
        this.extensionsManager = extensionsManager;
        Mockito.when((Object)this.extension1.getName()).thenReturn((Object)EXTENSION1_NAME);
        Mockito.when((Object)this.extension1.getConfigurations()).thenReturn(Arrays.asList(this.extension1Configuration));
        Mockito.when((Object)this.extension2.getName()).thenReturn((Object)EXTENSION2_NAME);
        Mockito.when((Object)this.extension1.getVersion()).thenReturn((Object)"3.6.0");
        Mockito.when((Object)this.extension2.getVersion()).thenReturn((Object)"3.6.0");
        Mockito.when((Object)this.extension1Configuration.getName()).thenReturn((Object)EXTENSION1_CONFIG_NAME);
        Mockito.when((Object)this.extension1Configuration.getInstantiator().newInstance()).thenReturn(this.configInstance);
        Mockito.when((Object)this.extension1Configuration.getInstantiator().getObjectType()).thenReturn(this.configInstance.getClass());
        Mockito.when((Object)this.extension1.getConfiguration(EXTENSION1_CONFIG_NAME)).thenReturn((Object)this.extension1Configuration);
        Mockito.when((Object)this.extension1.getOperation(EXTENSION1_OPERATION_NAME)).thenReturn((Object)this.extension1Operation);
        Mockito.when((Object)this.extension1Operation.getName()).thenReturn((Object)EXTENSION1_OPERATION_NAME);
        Mockito.when((Object)this.extension1OperationContext.getOperation()).thenReturn((Object)this.extension1Operation);
        Mockito.when((Object)this.extension1ConfigurationInstanceProvider.get((OperationContext)Matchers.same((Object)this.extension1OperationContext))).thenReturn(this.configInstance);
        Mockito.when((Object)this.extension1Operation.getExecutor()).thenReturn((Object)this.executor);
        this.classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        this.setDiscoverableExtensions(this.extension1, this.extension2);
        Mockito.when((Object)this.discoverer.discover((ClassLoader)Matchers.same((Object)this.classLoader))).thenAnswer((Answer)new Answer<List<Extension>>(){

            public List<Extension> answer(InvocationOnMock invocation) throws Throwable {
                return DefaultExtensionManagerTestCase.this.getTestExtensions();
            }
        });
        ExtensionsTestUtils.stubRegistryKeys(this.muleContext, EXTENSION1_CONFIG_INSTANCE_NAME, EXTENSION1_OPERATION_NAME, EXTENSION1_NAME);
    }

    private void setDiscoverableExtensions(Extension ... extensions) {
        Mockito.when((Object)this.discoverer.discover((ClassLoader)Matchers.same((Object)this.classLoader))).thenReturn(Arrays.asList(extensions));
    }

    @Test
    public void discover() {
        List extensions = this.extensionsManager.discoverExtensions(this.classLoader);
        ((ExtensionDiscoverer)Mockito.verify((Object)this.discoverer)).discover((ClassLoader)Matchers.same((Object)this.classLoader));
        this.testEquals(this.getTestExtensions(), extensions);
    }

    @Test
    public void getExtensions() {
        this.discover();
        this.testEquals(this.getTestExtensions(), this.extensionsManager.getExtensions());
    }

    @Test
    public void getExtensionsCapableOf() {
        Mockito.when((Object)this.extension1.isCapableOf(XmlCapability.class)).thenReturn((Object)true);
        Mockito.when((Object)this.extension2.isCapableOf(XmlCapability.class)).thenReturn((Object)false);
        this.discover();
        Set extensions = this.extensionsManager.getExtensionsCapableOf(XmlCapability.class);
        Assert.assertThat((Object)extensions, (Matcher)org.hamcrest.Matchers.hasSize((int)1));
        this.testEquals(this.extension1, (Extension)extensions.iterator().next());
    }

    @Test
    public void noExtensionsCapableOf() {
        Mockito.when((Object)this.extension1.isCapableOf(XmlCapability.class)).thenReturn((Object)false);
        Mockito.when((Object)this.extension2.isCapableOf(XmlCapability.class)).thenReturn((Object)false);
        this.discover();
        Set extensions = this.extensionsManager.getExtensionsCapableOf(XmlCapability.class);
        Assert.assertThat((Object)extensions.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test(expected=IllegalArgumentException.class)
    public void extensionsCapableOfNull() {
        this.extensionsManager.getExtensionsCapableOf(null);
    }

    @Test
    public void hotUpdateNewerExtension() {
        this.discover();
        Extension newerExtension = (Extension)Mockito.mock(Extension.class);
        Mockito.when((Object)newerExtension.getName()).thenReturn((Object)EXTENSION1_NAME);
        Mockito.when((Object)newerExtension.getVersion()).thenReturn((Object)NEWER_VERSION);
        this.setDiscoverableExtensions(newerExtension, this.extension2);
        List extensions = this.extensionsManager.discoverExtensions(this.classLoader);
        this.matchExtensions(extensions, Arrays.asList(newerExtension, this.extension2));
    }

    @Test
    public void hotUpdateOlderVersion() {
        this.discover();
        Extension olderExtension = (Extension)Mockito.mock(Extension.class);
        Mockito.when((Object)olderExtension.getName()).thenReturn((Object)EXTENSION1_NAME);
        Mockito.when((Object)olderExtension.getVersion()).thenReturn((Object)OLDER_VERSION);
        this.setDiscoverableExtensions(olderExtension, this.extension2);
        List extensions = this.extensionsManager.discoverExtensions(this.classLoader);
        this.matchToTestExtensions(extensions);
    }

    @Test
    public void hotUpdateWithNoChanges() {
        this.discover();
        List extensions = this.extensionsManager.discoverExtensions(this.classLoader);
        this.matchToTestExtensions(extensions);
    }

    @Test
    public void hotUpdateWithInvalidVersion() {
        this.discover();
        Extension invalidVersionExtension = (Extension)Mockito.mock(Extension.class);
        Mockito.when((Object)invalidVersionExtension.getName()).thenReturn((Object)EXTENSION1_NAME);
        Mockito.when((Object)invalidVersionExtension.getVersion()).thenReturn((Object)"brandnew");
        List extensions = this.extensionsManager.discoverExtensions(this.classLoader);
        this.matchToTestExtensions(extensions);
    }

    @Test
    public void contextClassLoaderKept() {
        this.discover();
        Assert.assertThat((Object)this.classLoader, (Matcher)CoreMatchers.sameInstance((Object)Thread.currentThread().getContextClassLoader()));
    }

    @Test
    public void contextClassLoaderKeptAfterException() {
        Mockito.when((Object)this.discoverer.discover((ClassLoader)Matchers.same((Object)this.classLoader))).thenThrow(new Class[]{RuntimeException.class});
        try {
            this.discover();
            Assert.fail((String)"was expecting an exception");
        }
        catch (RuntimeException e) {
            Assert.assertThat((Object)this.classLoader, (Matcher)CoreMatchers.sameInstance((Object)Thread.currentThread().getContextClassLoader()));
        }
    }

    @Test
    public void getConfigurationInstanceByName() throws Exception {
        this.discover();
        this.extensionsManager.registerConfigurationInstanceProvider(this.extension1, EXTENSION1_CONFIG_INSTANCE_NAME, this.extension1ConfigurationInstanceProvider);
        Object configurationInstance = this.extensionsManager.getConfigurationInstance(this.extension1, EXTENSION1_CONFIG_INSTANCE_NAME, (OperationContext)this.extension1OperationContext);
        Assert.assertThat((Object)configurationInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.configInstance)));
    }

    @Test
    public void getConfigurationInstanceThroughDefaultConfig() {
        this.discover();
        this.extensionsManager.registerConfigurationInstanceProvider(this.extension1, EXTENSION1_CONFIG_INSTANCE_NAME, this.extension1ConfigurationInstanceProvider);
        Object configurationInstance = this.extensionsManager.getConfigurationInstance(this.extension1, (OperationContext)this.extension1OperationContext);
        Assert.assertThat((Object)configurationInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.configInstance)));
    }

    @Test
    public void getConfigurationInstanceThroughImplicitConfiguration() {
        this.discover();
        Mockito.when((Object)this.extension1Configuration.getCapabilities(ParameterGroupCapability.class)).thenReturn(null);
        Object configurationInstance = this.extensionsManager.getConfigurationInstance(this.extension1, (OperationContext)this.extension1OperationContext);
        Assert.assertThat((Object)configurationInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.configInstance)));
    }

    @Test
    public void getOperationExecutorThroughImplicitConfigurationConcurrently() throws Exception {
        long timeout = 5L;
        final TimeUnit timeUnit = TimeUnit.SECONDS;
        int threadCount = 2;
        final Latch testLatch = new Latch();
        final CountDownLatch joinerLatch = new CountDownLatch(2);
        this.discover();
        Mockito.when((Object)this.extension1Configuration.getCapabilities(ParameterGroupCapability.class)).thenReturn(null);
        Mockito.when((Object)this.extension1.getConfigurations()).thenAnswer((Answer)new Answer<List<Configuration>>(){

            public List<Configuration> answer(InvocationOnMock invocation) throws Throwable {
                new Thread(){

                    @Override
                    public void run() {
                        testLatch.release();
                        DefaultExtensionManagerTestCase.this.extensionsManager.getConfigurationInstance(DefaultExtensionManagerTestCase.this.extension1, (OperationContext)DefaultExtensionManagerTestCase.this.extension1OperationContext);
                    }
                }.start();
                testLatch.await(5L, timeUnit);
                joinerLatch.countDown();
                return Arrays.asList(DefaultExtensionManagerTestCase.this.extension1Configuration);
            }
        });
        Object configurationInstance = this.extensionsManager.getConfigurationInstance(this.extension1, (OperationContext)this.extension1OperationContext);
        Assert.assertThat((Object)joinerLatch.await(5L, TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)configurationInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.configInstance)));
    }

    @Test(expected=IllegalStateException.class)
    public void getOperationExecutorWithNotImplicitConfig() {
        this.makeExtension1ConfigurationNotImplicit();
        this.discover();
        this.extensionsManager.getConfigurationInstance(this.extension1, (OperationContext)this.extension1OperationContext);
    }

    private void makeExtension1ConfigurationNotImplicit() {
        Parameter parameter1 = (Parameter)Mockito.mock(Parameter.class);
        Mockito.when((Object)parameter1.isRequired()).thenReturn((Object)true);
        Mockito.when((Object)this.extension1Configuration.getParameters()).thenReturn(Arrays.asList(parameter1, parameter1));
        Mockito.when((Object)this.extension1Configuration.getInstantiator().newInstance()).thenReturn(this.configInstance);
    }

    private List<Extension> getTestExtensions() {
        return ImmutableList.builder().add((Object)this.extension1).add((Object)this.extension2).build();
    }

    private void testEquals(Collection<Extension> expected, Collection<Extension> obtained) {
        Assert.assertThat((Object)obtained.size(), (Matcher)CoreMatchers.is((Object)expected.size()));
        Iterator<Extension> expectedIterator = expected.iterator();
        Iterator<Extension> obtainedIterator = expected.iterator();
        while (expectedIterator.hasNext()) {
            Assert.assertThat((Object)obtainedIterator.hasNext(), (Matcher)CoreMatchers.is((Object)true));
            this.testEquals(expectedIterator.next(), obtainedIterator.next());
        }
    }

    private void testEquals(Extension expected, Extension obtained) {
        Assert.assertThat((Object)obtained.getName(), (Matcher)CoreMatchers.equalTo((Object)expected.getName()));
        Assert.assertThat((Object)obtained.getVersion(), (Matcher)CoreMatchers.equalTo((Object)expected.getVersion()));
    }

    private void matchToTestExtensions(List<Extension> extensions) {
        this.matchExtensions(extensions, this.getTestExtensions());
    }

    private void matchExtensions(List<Extension> actual, List<Extension> expected) {
        Assert.assertThat(actual, (Matcher)org.hamcrest.Matchers.hasSize((int)expected.size()));
        Assert.assertThat(actual, (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])expected.toArray()));
    }
}

