/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.introspection;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.ArrayUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.extension.introspection.DataQualifier;
import org.mule.extension.introspection.DataQualifierVisitor;
import org.mule.module.extension.internal.introspection.SimpleTypeDataQualifierVisitor;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=Parameterized.class)
public class SimpleTypeDataQualifierVisitorTestCase
extends AbstractMuleTestCase {
    private static final DataQualifier[] SIMPLE_TYPES = new DataQualifier[]{DataQualifier.BOOLEAN, DataQualifier.INTEGER, DataQualifier.DOUBLE, DataQualifier.DECIMAL, DataQualifier.STRING, DataQualifier.LONG, DataQualifier.ENUM};
    @Parameterized.Parameter(value=0)
    public DataQualifier qualifier;
    private DataQualifierVisitor visitor = new SimpleTypeDataQualifierVisitor(){

        protected void onSimpleType() {
            SimpleTypeDataQualifierVisitorTestCase.this.simpleType = true;
        }

        protected void defaultOperation() {
            SimpleTypeDataQualifierVisitorTestCase.this.complexType = true;
        }
    };
    private boolean simpleType;
    private boolean complexType;

    @Parameterized.Parameters(name="isSimpleType({0})")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> types = new ArrayList<Object[]>();
        for (DataQualifier qualifier : DataQualifier.values()) {
            types.add(new Object[]{qualifier});
        }
        return types;
    }

    @Before
    public void before() {
        this.simpleType = false;
        this.complexType = false;
    }

    @Test
    public void assertSimpleOrNot() {
        this.qualifier.accept(this.visitor);
        boolean shouldBeSimple = ArrayUtils.contains((Object[])SIMPLE_TYPES, (Object)this.qualifier);
        Assert.assertThat((Object)this.simpleType, (Matcher)CoreMatchers.is((Object)shouldBeSimple));
        Assert.assertThat((Object)this.complexType, (Matcher)CoreMatchers.is((Object)(!shouldBeSimple ? 1 : 0)));
    }
}

