/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.introspection;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.api.registry.ServiceRegistry;
import org.mule.extension.introspection.declaration.fluent.DeclarationDescriptor;
import org.mule.module.extension.internal.introspection.CapabilitiesResolver;
import org.mule.module.extension.internal.introspection.DefaultCapabilitiesResolver;
import org.mule.registry.SpiServiceRegistry;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public abstract class AbstractCapabilitiesExtractorContractTestCase
extends AbstractMuleTestCase {
    protected CapabilitiesResolver resolver;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    protected DeclarationDescriptor declarationDescriptor;

    @Before
    public void before() {
        this.resolver = new DefaultCapabilitiesResolver((ServiceRegistry)new SpiServiceRegistry());
    }

    @Test
    public void noCapability() {
        this.resolver.resolveCapabilities(this.declarationDescriptor, ((Object)((Object)this)).getClass());
        ((DeclarationDescriptor)Mockito.verify((Object)this.declarationDescriptor, (VerificationMode)Mockito.never())).withCapability(Matchers.anyObject());
    }

    @Test(expected=IllegalArgumentException.class)
    public void nullClass() {
        this.resolver.resolveCapabilities(this.declarationDescriptor, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void nullDeclaration() {
        this.resolver.resolveCapabilities(null, ((Object)((Object)this)).getClass());
    }
}

