/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.api.registry.ServiceRegistry;
import org.mule.extension.exception.NoSuchConfigurationException;
import org.mule.extension.exception.NoSuchOperationException;
import org.mule.extension.introspection.Configuration;
import org.mule.extension.introspection.ConfigurationInstantiator;
import org.mule.extension.introspection.DataQualifier;
import org.mule.extension.introspection.DataType;
import org.mule.extension.introspection.Extension;
import org.mule.extension.introspection.ExtensionFactory;
import org.mule.extension.introspection.Operation;
import org.mule.extension.introspection.Parameter;
import org.mule.extension.introspection.declaration.DescribingContext;
import org.mule.extension.introspection.declaration.fluent.DeclarationDescriptor;
import org.mule.extension.introspection.declaration.fluent.Descriptor;
import org.mule.extension.introspection.declaration.spi.DescriberPostProcessor;
import org.mule.extension.introspection.declaration.tck.TestWebServiceConsumerDeclarationReference;
import org.mule.module.extension.internal.introspection.DefaultExtensionFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ExtensionBuildersTestCase
extends AbstractMuleTestCase {
    @Mock
    private ServiceRegistry serviceRegistry;
    private DeclarationDescriptor descriptor;
    private Extension extension;
    private ExtensionFactory factory;

    @Before
    public void buildExtension() throws Exception {
        List emptyList = Collections.emptyList();
        Mockito.when((Object)this.serviceRegistry.lookupProviders((Class)org.mockito.Matchers.same(DescriberPostProcessor.class))).thenReturn(emptyList);
        Mockito.when((Object)this.serviceRegistry.lookupProviders((Class)org.mockito.Matchers.same(DescriberPostProcessor.class), (ClassLoader)org.mockito.Matchers.any(ClassLoader.class))).thenReturn(emptyList);
        this.factory = new DefaultExtensionFactory(this.serviceRegistry);
        this.descriptor = this.createDeclarationDescriptor();
        this.extension = this.factory.createFrom((Descriptor)this.descriptor);
    }

    @Test
    public void assertExtension() {
        Assert.assertThat((Object)this.extension.getName(), (Matcher)CoreMatchers.equalTo((Object)"WSConsumer"));
        Assert.assertThat((Object)this.extension.getDescription(), (Matcher)CoreMatchers.equalTo((Object)"Generic Consumer for SOAP Web Services"));
        Assert.assertThat((Object)this.extension.getVersion(), (Matcher)CoreMatchers.equalTo((Object)"3.6.0"));
        Assert.assertThat((Object)this.extension.getConfigurations(), (Matcher)Matchers.hasSize((int)1));
        Set capabilities = this.extension.getCapabilities(Object.class);
        Assert.assertThat((Object)capabilities, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)capabilities, (Matcher)Matchers.hasSize((int)1));
        ((ServiceRegistry)Mockito.verify((Object)this.serviceRegistry)).lookupProviders((Class)org.mockito.Matchers.any(Class.class), (ClassLoader)org.mockito.Matchers.any(ClassLoader.class));
    }

    @Test
    public void defaultConfiguration() throws Exception {
        Configuration configuration = this.extension.getConfiguration("config");
        Assert.assertThat((Object)configuration, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)configuration.getName(), (Matcher)CoreMatchers.equalTo((Object)"config"));
        Assert.assertThat((Object)configuration.getDescription(), (Matcher)CoreMatchers.equalTo((Object)"Default description"));
        List parameters = configuration.getParameters();
        Assert.assertThat((Object)parameters, (Matcher)Matchers.hasSize((int)4));
        this.assertParameter((Parameter)parameters.get(0), "address", "Service address", true, true, DataType.of(String.class), DataQualifier.STRING, null);
        this.assertParameter((Parameter)parameters.get(1), "port", "Service Port", true, true, DataType.of(String.class), DataQualifier.STRING, null);
        this.assertParameter((Parameter)parameters.get(2), "service", "Service Name", true, true, DataType.of(String.class), DataQualifier.STRING, null);
        this.assertParameter((Parameter)parameters.get(3), "wsdlLocation", "URI to find the WSDL", false, true, DataType.of(String.class), DataQualifier.STRING, null);
    }

    @Test
    public void onlyOneConfig() throws Exception {
        Assert.assertThat((Object)this.extension.getConfigurations(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(this.extension.getConfigurations().get(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.extension.getConfiguration("config"))));
    }

    @Test(expected=NoSuchConfigurationException.class)
    public void noSuchConfiguration() throws Exception {
        this.extension.getConfiguration("fake");
    }

    @Test(expected=NoSuchOperationException.class)
    public void noSuchOperation() throws Exception {
        this.extension.getOperation("fake");
    }

    @Test
    public void noSuchCapability() {
        Set capabilities = this.extension.getCapabilities(String.class);
        Assert.assertThat((Object)capabilities, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)capabilities, (Matcher)Matchers.hasSize((int)0));
    }

    @Test(expected=IllegalArgumentException.class)
    public void nullCapability() {
        this.factory.createFrom((Descriptor)this.createDeclarationDescriptor().withCapability(null));
    }

    @Test
    public void operations() throws Exception {
        List operations = this.extension.getOperations();
        Assert.assertThat((Object)operations, (Matcher)Matchers.hasSize((int)3));
        this.assertConsumeOperation(operations);
        this.assertBroadcastOperation(operations);
        this.assertArglessOperation(operations);
    }

    @Test(expected=IllegalArgumentException.class)
    public void badExtensionVersion() {
        this.factory.createFrom((Descriptor)new DeclarationDescriptor("bad", "i'm new"));
    }

    @Test
    public void configurationsOrder() {
        ConfigurationInstantiator mockInstantiator = (ConfigurationInstantiator)Mockito.mock(ConfigurationInstantiator.class);
        String defaultConfiguration = "default";
        String beta = "beta";
        String alpha = "alpha";
        Extension extension = this.factory.createFrom((Descriptor)new DeclarationDescriptor("test", "1.0").withConfig("default").describedAs("default").instantiatedWith(mockInstantiator).withConfig("beta").describedAs("beta").instantiatedWith(mockInstantiator).withConfig("alpha").describedAs("alpha").instantiatedWith(mockInstantiator));
        List configurations = extension.getConfigurations();
        Assert.assertThat((Object)configurations, (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat((Object)((Configuration)configurations.get(1)).getName(), (Matcher)CoreMatchers.equalTo((Object)"alpha"));
        Assert.assertThat((Object)((Configuration)configurations.get(2)).getName(), (Matcher)CoreMatchers.equalTo((Object)"beta"));
    }

    @Test
    public void operationsAlphaSorted() {
        Assert.assertThat((Object)this.extension.getOperations(), (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat((Object)((Operation)this.extension.getOperations().get(0)).getName(), (Matcher)CoreMatchers.equalTo((Object)"argLess"));
        Assert.assertThat((Object)((Operation)this.extension.getOperations().get(1)).getName(), (Matcher)CoreMatchers.equalTo((Object)"broadcast"));
        Assert.assertThat((Object)((Operation)this.extension.getOperations().get(2)).getName(), (Matcher)CoreMatchers.equalTo((Object)"consumer"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void nameClashes() {
        this.factory.createFrom((Descriptor)this.descriptor.withConfig("config").describedAs(""));
    }

    @Test(expected=IllegalArgumentException.class)
    public void operationWithParameterNamedName() {
        this.factory.createFrom((Descriptor)this.descriptor.withOperation("invalidOperation").describedAs("").with().requiredParameter("name").ofType(String.class, new Class[0]));
    }

    @Test(expected=IllegalArgumentException.class)
    public void nameWithSpaces() {
        this.descriptor = new DeclarationDescriptor("i have spaces", "1.0").withConfig("default").getRootDeclaration();
        this.factory.createFrom((Descriptor)this.descriptor);
    }

    @Test(expected=IllegalArgumentException.class)
    public void configlessDescriptor() {
        this.factory.createFrom((Descriptor)new DeclarationDescriptor("noConfigs", "1.0"));
    }

    @Test
    public void postProcessorsInvoked() throws Exception {
        DescriberPostProcessor postProcessor1 = (DescriberPostProcessor)Mockito.mock(DescriberPostProcessor.class);
        DescriberPostProcessor postProcessor2 = (DescriberPostProcessor)Mockito.mock(DescriberPostProcessor.class);
        Mockito.when((Object)this.serviceRegistry.lookupProviders((Class)org.mockito.Matchers.same(DescriberPostProcessor.class), (ClassLoader)org.mockito.Matchers.any(ClassLoader.class))).thenReturn(Arrays.asList(postProcessor1, postProcessor2));
        this.factory = new DefaultExtensionFactory(this.serviceRegistry);
        this.factory.createFrom((Descriptor)this.descriptor);
        this.assertDescribingContext(postProcessor1);
        this.assertDescribingContext(postProcessor2);
    }

    private void assertDescribingContext(DescriberPostProcessor postProcessor) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(DescribingContext.class);
        ((DescriberPostProcessor)Mockito.verify((Object)postProcessor)).postProcess((DescribingContext)captor.capture());
        DescribingContext ctx = (DescribingContext)captor.getValue();
        Assert.assertThat((Object)ctx, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)ctx.getDeclarationDescriptor(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.descriptor)));
    }

    private void assertConsumeOperation(List<Operation> operations) throws NoSuchOperationException {
        Operation operation = operations.get(2);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.extension.getOperation("consumer"))));
        Assert.assertThat((Object)operation.getName(), (Matcher)CoreMatchers.equalTo((Object)"consumer"));
        Assert.assertThat((Object)operation.getDescription(), (Matcher)CoreMatchers.equalTo((Object)"Go get them tiger"));
        List parameters = operation.getParameters();
        Assert.assertThat((Object)parameters, (Matcher)Matchers.hasSize((int)2));
        this.assertParameter((Parameter)parameters.get(0), "operation", "The operation to use", true, true, DataType.of(String.class), DataQualifier.STRING, null);
        this.assertParameter((Parameter)parameters.get(1), "mtomEnabled", "Whether or not use MTOM for attachments", true, false, DataType.of(Boolean.class), DataQualifier.BOOLEAN, true);
    }

    private void assertBroadcastOperation(List<Operation> operations) throws NoSuchOperationException {
        Operation operation = operations.get(1);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.extension.getOperation("broadcast"))));
        Assert.assertThat((Object)operation.getName(), (Matcher)CoreMatchers.equalTo((Object)"broadcast"));
        Assert.assertThat((Object)operation.getDescription(), (Matcher)CoreMatchers.equalTo((Object)"consumes many services"));
        List parameters = operation.getParameters();
        Assert.assertThat((Object)parameters, (Matcher)Matchers.hasSize((int)3));
        this.assertParameter((Parameter)parameters.get(0), "operation", "The operation to use", true, true, DataType.of(List.class, (Class[])new Class[]{String.class}), DataQualifier.LIST, null);
        this.assertParameter((Parameter)parameters.get(1), "mtomEnabled", "Whether or not use MTOM for attachments", true, false, DataType.of(Boolean.class), DataQualifier.BOOLEAN, true);
        this.assertParameter((Parameter)parameters.get(2), "callback", "async callback", false, true, DataType.of(Operation.class), DataQualifier.OPERATION, null);
    }

    private void assertArglessOperation(List<Operation> operations) throws NoSuchOperationException {
        Operation operation = operations.get(0);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.extension.getOperation("argLess"))));
        Assert.assertThat((Object)operation.getName(), (Matcher)CoreMatchers.equalTo((Object)"argLess"));
        Assert.assertThat((Object)operation.getDescription(), (Matcher)CoreMatchers.equalTo((Object)"has no args"));
        List parameters = operation.getParameters();
        Assert.assertThat((Object)parameters.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    private void assertParameter(Parameter parameter, String name, String description, boolean acceptsExpressions, boolean required, DataType type, DataQualifier qualifier, Object defaultValue) {
        Assert.assertThat((Object)parameter, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)parameter.getName(), (Matcher)CoreMatchers.equalTo((Object)name));
        Assert.assertThat((Object)parameter.getDescription(), (Matcher)CoreMatchers.equalTo((Object)description));
        Assert.assertThat((Object)parameter.isDynamic(), (Matcher)CoreMatchers.is((Object)acceptsExpressions));
        Assert.assertThat((Object)parameter.isRequired(), (Matcher)CoreMatchers.is((Object)required));
        Assert.assertThat((Object)parameter.getType(), (Matcher)CoreMatchers.equalTo((Object)type));
        Assert.assertThat((Object)parameter.getType().getQualifier(), (Matcher)CoreMatchers.is((Object)qualifier));
        if (defaultValue != null) {
            Assert.assertThat((Object)parameter.getDefaultValue(), (Matcher)CoreMatchers.equalTo((Object)defaultValue));
        } else {
            Assert.assertThat((Object)parameter.getDefaultValue(), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
        }
    }

    private DeclarationDescriptor createDeclarationDescriptor() {
        return new TestWebServiceConsumerDeclarationReference().getDescriptor();
    }
}

