/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal;

import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.extension.annotations.Extensible;
import org.mule.extension.annotations.Extension;
import org.mule.extension.annotations.ExtensionOf;
import org.mule.extension.annotations.Operation;
import org.mule.extension.annotations.Operations;
import org.mule.extension.introspection.declaration.fluent.Declaration;
import org.mule.extension.introspection.declaration.fluent.OperationDeclaration;
import org.mule.module.extension.internal.AbstractAnnotationsBasedDescriberTestCase;
import org.mule.module.extension.internal.capability.metadata.ExtendingOperationCapability;

public class ExtensibleExtensionOperationsTestCase
extends AbstractAnnotationsBasedDescriberTestCase {
    private static final String SAY_HELLO_OPERATION = "sayHello";
    private static final String SAY_BYE_OPERATION = "sayBye";

    @Test
    public void operationIsExtensionOfSameExtension() throws Exception {
        this.setDescriber(this.describerFor(ExtensibleExtension.class));
        this.assertOperationExtensionOf(SAY_HELLO_OPERATION, ExtensibleExtension.class);
    }

    @Test
    public void operationIsExtensionOfDifferentExtension() {
        this.setDescriber(this.describerFor(ExtendingExtension.class));
        this.assertOperationExtensionOf(SAY_HELLO_OPERATION, ExtensibleExtension.class);
        this.assertOperationExtensionOf(SAY_BYE_OPERATION, ExtensibleExtension.class);
    }

    @Test
    public void operationIsExtensionOfSameAndDifferentExtension() {
        this.setDescriber(this.describerFor(ExtensibleExtendingExtension.class));
        this.assertOperationExtensionOf(SAY_HELLO_OPERATION, ExtensibleExtendingExtension.class);
        this.assertOperationExtensionOf(SAY_BYE_OPERATION, ExtensibleExtension.class);
    }

    private void assertOperationExtensionOf(String operationName, Class capabilityType) {
        Declaration declaration = this.getDescriber().describe().getRootDeclaration().getDeclaration();
        OperationDeclaration operation = this.getOperation(declaration, operationName);
        Assert.assertThat((Object)operation.getCapabilities(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)Matchers.emptyIterable())));
        Set extendingOperationCapabilities = operation.getCapabilities(ExtendingOperationCapability.class);
        Assert.assertThat((Object)extendingOperationCapabilities, (Matcher)Matchers.hasSize((int)1));
        ExtendingOperationCapability capability = (ExtendingOperationCapability)extendingOperationCapabilities.iterator().next();
        Assert.assertThat((Object)capability.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)capabilityType)));
    }

    private static class ExtensibleExtensionOperation {
        private ExtensibleExtensionOperation() {
        }

        @Operation
        public String sayHello() {
            return "Hello!";
        }
    }

    private static class MethodLevelExtensionOfOperation {
        private MethodLevelExtensionOfOperation() {
        }

        @ExtensionOf(value=ExtensibleExtension.class)
        @Operation
        public String sayBye() {
            return "Bye!";
        }
    }

    @ExtensionOf(value=ExtensibleExtension.class)
    private static class ClassLevelExtensionOfOperation {
        private ClassLevelExtensionOfOperation() {
        }

        @Operation
        public String sayHello() {
            return "Hello!";
        }
    }

    @Extension(name="heisenberg", description="My Test Extension just to unit test", version="1.0")
    @Operations(value={MethodLevelExtensionOfOperation.class, ExtensibleExtensionOperation.class})
    @Extensible
    public static class ExtensibleExtendingExtension {
    }

    @Extension(name="heisenberg", description="My Test Extension just to unit test", version="1.0")
    @Operations(value={ClassLevelExtensionOfOperation.class, MethodLevelExtensionOfOperation.class})
    public static class ExtendingExtension {
    }

    @Extension(name="heisenberg", description="My Test Extension just to unit test", version="1.0")
    @Operations(value={ExtensibleExtensionOperation.class})
    @Extensible
    public static class ExtensibleExtension {
    }
}

