/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Predicate;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.extension.annotations.Configuration;
import org.mule.extension.annotations.Configurations;
import org.mule.extension.annotations.Extension;
import org.mule.extension.annotations.Operation;
import org.mule.extension.annotations.Operations;
import org.mule.extension.annotations.Parameter;
import org.mule.extension.annotations.capability.Xml;
import org.mule.extension.introspection.DataType;
import org.mule.extension.introspection.declaration.fluent.ConfigurationDeclaration;
import org.mule.extension.introspection.declaration.fluent.Declaration;
import org.mule.extension.introspection.declaration.fluent.Descriptor;
import org.mule.extension.introspection.declaration.fluent.OperationDeclaration;
import org.mule.extension.introspection.declaration.fluent.ParameterDeclaration;
import org.mule.module.extension.HealthStatus;
import org.mule.module.extension.HeisenbergExtension;
import org.mule.module.extension.HeisenbergOperations;
import org.mule.module.extension.KnockeableDoor;
import org.mule.module.extension.MoneyLaunderingOperation;
import org.mule.module.extension.Ricin;
import org.mule.module.extension.internal.AbstractAnnotationsBasedDescriberTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.util.CollectionUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class AnnotationsBasedDescriberTestCase
extends AbstractAnnotationsBasedDescriberTestCase {
    private static final String EXTENDED_CONFIG_NAME = "extendedConfig";
    private static final String EXTENDED_CONFIG_DESCRIPTION = "extendedDescription";
    private static final String SAY_MY_NAME_OPERATION = "sayMyName";
    private static final String GET_ENEMY_OPERATION = "getEnemy";
    private static final String KILL_OPERATION = "kill";
    private static final String KILL_CUSTOM_OPERATION = "killWithCustomMessage";
    private static final String HIDE_METH_IN_EVENT_OPERATION = "hideMethInEvent";
    private static final String HIDE_METH_IN_MESSAGE_OPERATION = "hideMethInMessage";
    private static final String DIE = "die";
    private static final String KILL_MANY = "killMany";
    private static final String KILL_ONE = "killOne";
    private static final String LAUNDER_MONEY = "launder";
    private static final String INJECTED_EXTENSION_MANAGER = "getInjectedExtensionManager";
    private static final String ALIAS = "alias";

    @Before
    public void setUp() {
        this.setDescriber(this.describerFor(HeisenbergExtension.class));
    }

    @Test
    public void describeTestModule() throws Exception {
        Descriptor descriptor = this.getDescriber().describe();
        Declaration declaration = descriptor.getRootDeclaration().getDeclaration();
        this.assertExtensionProperties(declaration);
        this.assertTestModuleConfiguration(declaration);
        this.assertTestModuleOperations(declaration);
        this.assertCapabilities(declaration);
    }

    @Test
    public void heisenbergPointer() throws Exception {
        this.setDescriber(this.describerFor(HeisenbergPointer.class));
        this.describeTestModule();
    }

    @Test
    public void heisenbergPointerPlusExternalConfig() throws Exception {
        this.setDescriber(this.describerFor(HeisengergPointerPlusExternalConfig.class));
        Declaration declaration = this.getDescriber().describe().getRootDeclaration().getDeclaration();
        this.assertExtensionProperties(declaration);
        Assert.assertThat((Object)declaration.getConfigurations().size(), (Matcher)CoreMatchers.equalTo((Object)2));
        ConfigurationDeclaration configuration = (ConfigurationDeclaration)declaration.getConfigurations().get(1);
        Assert.assertThat((Object)configuration, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)configuration.getName(), (Matcher)CoreMatchers.equalTo((Object)EXTENDED_CONFIG_NAME));
        Assert.assertThat((Object)configuration.getParameters(), (Matcher)Matchers.hasSize((int)1));
        this.assertParameter(configuration.getParameters(), "extendedProperty", "", DataType.of(String.class), true, true, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void heisenbergWithOperationsConfig() throws Exception {
        this.describerFor(HeisenbergWithOperations.class).describe();
    }

    private void assertTestModuleConfiguration(Declaration declaration) throws Exception {
        Assert.assertThat((Object)declaration.getConfigurations(), (Matcher)Matchers.hasSize((int)1));
        ConfigurationDeclaration conf = (ConfigurationDeclaration)declaration.getConfigurations().get(0);
        Assert.assertThat((Object)conf.getName(), (Matcher)CoreMatchers.equalTo((Object)"config"));
        List parameters = conf.getParameters();
        Assert.assertThat((Object)parameters, (Matcher)Matchers.hasSize((int)13));
        this.assertParameter(parameters, "myName", "", DataType.of(String.class), false, true, "Heisenberg");
        this.assertParameter(parameters, "age", "", DataType.of(Integer.class), false, true, "50");
        this.assertParameter(parameters, "enemies", "", DataType.of(List.class, (Class[])new Class[]{String.class}), true, true, null);
        this.assertParameter(parameters, "money", "", DataType.of(BigDecimal.class), true, true, null);
        this.assertParameter(parameters, "cancer", "", DataType.of(Boolean.TYPE), true, true, null);
        this.assertParameter(parameters, "cancer", "", DataType.of(Boolean.TYPE), true, true, null);
        this.assertParameter(parameters, "dateOfBirth", "", DataType.of(Date.class), true, true, null);
        this.assertParameter(parameters, "dateOfDeath", "", DataType.of(Calendar.class), true, true, null);
        this.assertParameter(parameters, "recipe", "", DataType.of(Map.class, (Class[])new Class[]{String.class, Long.class}), false, true, null);
        this.assertParameter(parameters, "ricinPacks", "", DataType.of(Set.class, (Class[])new Class[]{Ricin.class}), false, true, null);
        this.assertParameter(parameters, "nextDoor", "", DataType.of(KnockeableDoor.class), false, true, null);
        this.assertParameter(parameters, "candidateDoors", "", DataType.of(Map.class, (Class[])new Class[]{String.class, KnockeableDoor.class}), false, true, null);
        this.assertParameter(parameters, "initialHealth", "", DataType.of(HealthStatus.class), true, true, null);
        this.assertParameter(parameters, "finalHealth", "", DataType.of(HealthStatus.class), true, true, null);
    }

    private void assertExtensionProperties(Declaration declaration) {
        Assert.assertThat((Object)declaration, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)declaration.getName(), (Matcher)CoreMatchers.is((Object)"heisenberg"));
        Assert.assertThat((Object)declaration.getDescription(), (Matcher)CoreMatchers.is((Object)"My Test Extension just to unit test"));
        Assert.assertThat((Object)declaration.getVersion(), (Matcher)CoreMatchers.is((Object)"1.0"));
    }

    private void assertTestModuleOperations(Declaration declaration) throws Exception {
        Assert.assertThat((Object)declaration.getOperations(), (Matcher)Matchers.hasSize((int)12));
        this.assertOperation(declaration, SAY_MY_NAME_OPERATION, "");
        this.assertOperation(declaration, GET_ENEMY_OPERATION, "");
        this.assertOperation(declaration, KILL_OPERATION, "");
        this.assertOperation(declaration, KILL_CUSTOM_OPERATION, "");
        this.assertOperation(declaration, HIDE_METH_IN_EVENT_OPERATION, "");
        this.assertOperation(declaration, HIDE_METH_IN_MESSAGE_OPERATION, "");
        this.assertOperation(declaration, DIE, "");
        this.assertOperation(declaration, KILL_MANY, "");
        this.assertOperation(declaration, KILL_ONE, "");
        this.assertOperation(declaration, LAUNDER_MONEY, "");
        this.assertOperation(declaration, INJECTED_EXTENSION_MANAGER, "");
        this.assertOperation(declaration, ALIAS, "");
        OperationDeclaration operation = this.getOperation(declaration, SAY_MY_NAME_OPERATION);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)operation.getParameters().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        operation = this.getOperation(declaration, GET_ENEMY_OPERATION);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)operation.getParameters(), (Matcher)Matchers.hasSize((int)1));
        this.assertParameter(operation.getParameters(), "index", "", DataType.of(Integer.TYPE), true, true, null);
        operation = this.getOperation(declaration, KILL_OPERATION);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)operation.getParameters(), (Matcher)Matchers.hasSize((int)2));
        this.assertParameter(operation.getParameters(), "victim", "", DataType.of(String.class), false, true, "#[payload]");
        this.assertParameter(operation.getParameters(), "goodbyeMessage", "", DataType.of(String.class), true, true, null);
        operation = this.getOperation(declaration, KILL_CUSTOM_OPERATION);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)operation.getParameters(), (Matcher)Matchers.hasSize((int)2));
        this.assertParameter(operation.getParameters(), "victim", "", DataType.of(String.class), false, true, "#[payload]");
        this.assertParameter(operation.getParameters(), "goodbyeMessage", "", DataType.of(String.class), true, true, null);
        operation = this.getOperation(declaration, HIDE_METH_IN_EVENT_OPERATION);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)operation.getParameters().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        operation = this.getOperation(declaration, HIDE_METH_IN_MESSAGE_OPERATION);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)operation.getParameters().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        operation = this.getOperation(declaration, LAUNDER_MONEY);
        this.assertParameter(operation.getParameters(), "amount", "", DataType.of(Long.TYPE), true, true, null);
        operation = this.getOperation(declaration, INJECTED_EXTENSION_MANAGER);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)operation.getParameters().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        operation = this.getOperation(declaration, ALIAS);
        this.assertParameter(operation.getParameters(), "greeting", "", DataType.of(String.class), true, true, null);
        this.assertParameter(operation.getParameters(), "myName", "", DataType.of(String.class), false, true, "Heisenberg");
        this.assertParameter(operation.getParameters(), "age", "", DataType.of(Integer.class), false, true, "50");
    }

    private void assertOperation(Declaration declaration, String operationName, String operationDescription) throws Exception {
        OperationDeclaration operation = this.getOperation(declaration, operationName);
        Assert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)operation.getDescription(), (Matcher)CoreMatchers.equalTo((Object)operationDescription));
    }

    private void assertParameter(List<ParameterDeclaration> parameters, String name, String description, DataType dataType, boolean required, boolean dynamic, Object defaultValue) {
        ParameterDeclaration param = this.findParameter(parameters, name);
        Assert.assertThat((Object)param, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)param.getName(), (Matcher)CoreMatchers.equalTo((Object)name));
        Assert.assertThat((Object)param.getDescription(), (Matcher)CoreMatchers.equalTo((Object)description));
        Assert.assertThat((Object)param.getType(), (Matcher)CoreMatchers.equalTo((Object)dataType));
        Assert.assertThat((Object)param.isRequired(), (Matcher)CoreMatchers.is((Object)required));
        Assert.assertThat((Object)param.isDynamic(), (Matcher)CoreMatchers.is((Object)dynamic));
        Assert.assertThat((Object)param.getDefaultValue(), (Matcher)CoreMatchers.equalTo((Object)defaultValue));
    }

    private ParameterDeclaration findParameter(List<ParameterDeclaration> parameters, final String name) {
        return (ParameterDeclaration)CollectionUtils.find(parameters, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return name.equals(((ParameterDeclaration)object).getName());
            }
        });
    }

    protected void assertCapabilities(Declaration declaration) {
    }

    public static class HeisenbergAlternateConfig {
        @Parameter
        private String extendedProperty;

        public String getExtendedProperty() {
            return this.extendedProperty;
        }

        public void setExtendedProperty(String extendedProperty) {
            this.extendedProperty = extendedProperty;
        }
    }

    @Extension(name="heisenberg", description="My Test Extension just to unit test", version="1.0")
    public static class HeisenbergWithOperations
    extends HeisenbergExtension {
        @Operation
        public void invalid() {
        }
    }

    @Configuration(name="extendedConfig", description="extendedDescription")
    @Operations(value={HeisenbergOperations.class, MoneyLaunderingOperation.class})
    public static class NamedHeisenbergAlternateConfig
    extends HeisenbergAlternateConfig {
    }

    @Extension(name="heisenberg", description="My Test Extension just to unit test", version="1.0")
    @Xml(schemaLocation="http://www.mulesoft.org/schema/mule/heisenberg", namespace="heisenberg", schemaVersion="1.0-blue")
    @Configurations(value={HeisenbergExtension.class, NamedHeisenbergAlternateConfig.class})
    @Operations(value={HeisenbergOperations.class, MoneyLaunderingOperation.class})
    public static class HeisengergPointerPlusExternalConfig {
    }

    @Extension(name="heisenberg", description="My Test Extension just to unit test", version="1.0")
    @Xml(schemaLocation="http://www.mulesoft.org/schema/mule/heisenberg", namespace="heisenberg", schemaVersion="1.0-blue")
    @Configurations(value={HeisenbergExtension.class})
    @Operations(value={HeisenbergOperations.class, MoneyLaunderingOperation.class})
    public static class HeisenbergPointer
    extends HeisenbergExtension {
    }
}

