/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension;

import java.util.List;
import javax.inject.Inject;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.NestedProcessor;
import org.mule.api.transport.PropertyScope;
import org.mule.extension.ExtensionManager;
import org.mule.extension.annotations.Operation;
import org.mule.extension.annotations.ParameterGroup;
import org.mule.extension.annotations.RestrictedTo;
import org.mule.extension.annotations.param.Optional;
import org.mule.extension.annotations.param.Payload;
import org.mule.extension.annotations.param.UseConfig;
import org.mule.module.extension.HealthStatus;
import org.mule.module.extension.HeisenbergExtension;
import org.mule.module.extension.PersonalInfo;

public class HeisenbergOperations {
    private static final String SECRET_PACKAGE = "secretPackage";
    private static final String METH = "meth";
    @Inject
    private ExtensionManager extensionManager;

    @Operation
    public String sayMyName(@UseConfig HeisenbergExtension config) {
        return config.getPersonalInfo().getName();
    }

    @Operation
    public void die(@UseConfig HeisenbergExtension config) {
        config.setEndingHealth(HealthStatus.DEAD);
    }

    @Operation
    public String getEnemy(@UseConfig HeisenbergExtension config, int index) {
        return config.getEnemies().get(index);
    }

    @Operation
    public String kill(@Payload String victim, String goodbyeMessage) throws Exception {
        return this.killWithCustomMessage(victim, goodbyeMessage);
    }

    @Operation
    public String killWithCustomMessage(@Optional(defaultValue="#[payload]") String victim, String goodbyeMessage) {
        return String.format("%s, %s", goodbyeMessage, victim);
    }

    @Operation
    public String killMany(@RestrictedTo(value=HeisenbergExtension.class) List<NestedProcessor> killOperations, String reason) throws Exception {
        StringBuilder builder = new StringBuilder("Killed the following because " + reason + ":\n");
        for (NestedProcessor processor : killOperations) {
            builder.append(processor.process()).append("\n");
        }
        return builder.toString();
    }

    @Operation
    public String killOne(@RestrictedTo(value=HeisenbergExtension.class) NestedProcessor killOperation, String reason) throws Exception {
        StringBuilder builder = new StringBuilder("Killed the following because " + reason + ":\n");
        builder.append(killOperation.process()).append("\n");
        return builder.toString();
    }

    @Operation
    public ExtensionManager getInjectedExtensionManager() {
        return this.extensionManager;
    }

    @Operation
    public void hideMethInEvent(MuleEvent event) {
        event.setFlowVariable(SECRET_PACKAGE, (Object)METH);
    }

    @Operation
    public String alias(String greeting, @ParameterGroup PersonalInfo info) {
        return String.format("%s, my name is %s and I'm %d years old", greeting, info.getName(), info.getAge());
    }

    @Operation
    public void hideMethInMessage(MuleMessage message) {
        message.setProperty(SECRET_PACKAGE, (Object)METH, PropertyScope.INVOCATION);
    }
}

