/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.resources;

import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.mule.api.registry.ServiceRegistry;
import org.mule.extension.resources.GeneratedResource;
import org.mule.module.extension.internal.resources.AbstractResourcesGenerator;

final class AnnotationProcessorResourceGenerator
extends AbstractResourcesGenerator {
    private final ProcessingEnvironment processingEnv;

    public AnnotationProcessorResourceGenerator(ProcessingEnvironment processingEnv, ServiceRegistry serviceRegistry) {
        super(serviceRegistry);
        this.processingEnv = processingEnv;
    }

    protected void write(GeneratedResource resource) {
        FileObject file;
        try {
            file = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", resource.getFilePath(), new Element[0]);
        }
        catch (IOException e) {
            throw this.wrapException(e, resource);
        }
        try (OutputStream out = file.openOutputStream();){
            out.write(resource.getContentBuilder().toString().getBytes());
            out.flush();
        }
        catch (IOException e) {
            throw this.wrapException(e, resource);
        }
    }

    private RuntimeException wrapException(Exception e, GeneratedResource resource) {
        return new RuntimeException(String.format("Could not write generated resource '%s'", resource.getFilePath()), e);
    }
}

