/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.config;

import org.mule.api.MuleContext;
import org.mule.api.MuleRuntimeException;
import org.mule.extension.introspection.Configuration;
import org.mule.extension.introspection.Extension;
import org.mule.extension.runtime.ConfigurationInstanceProvider;
import org.mule.extension.runtime.ConfigurationInstanceRegistrationCallback;
import org.mule.module.extension.internal.config.ElementDescriptor;
import org.mule.module.extension.internal.config.XmlExtensionParserUtils;
import org.mule.module.extension.internal.manager.ExtensionManagerAdapter;
import org.mule.module.extension.internal.runtime.ConfigurationObjectBuilder;
import org.mule.module.extension.internal.runtime.DynamicConfigurationInstanceProvider;
import org.mule.module.extension.internal.runtime.StaticConfigurationInstanceProvider;
import org.mule.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.module.extension.internal.util.MuleExtensionUtils;
import org.springframework.beans.factory.FactoryBean;

final class ConfigurationInstanceProviderFactoryBean
implements FactoryBean<ConfigurationInstanceProvider<Object>> {
    private final ConfigurationInstanceProvider<Object> configurationInstanceProvider;

    ConfigurationInstanceProviderFactoryBean(String name, Extension extension, Configuration configuration, ElementDescriptor element, MuleContext muleContext) {
        ExtensionManagerAdapter extensionManager = (ExtensionManagerAdapter)muleContext.getExtensionManager();
        ResolverSet resolverSet = XmlExtensionParserUtils.getResolverSet(element, configuration.getParameters());
        ConfigurationObjectBuilder configurationObjectBuilder = new ConfigurationObjectBuilder(name, extension, configuration, resolverSet, (ConfigurationInstanceRegistrationCallback)extensionManager);
        if (resolverSet.isDynamic()) {
            this.configurationInstanceProvider = new DynamicConfigurationInstanceProvider(configurationObjectBuilder, resolverSet);
        } else {
            Object configurationInstance = this.instantiateStaticConfiguration(muleContext, configurationObjectBuilder);
            this.configurationInstanceProvider = new StaticConfigurationInstanceProvider(configurationInstance);
        }
        extensionManager.registerConfigurationInstanceProvider(extension, name, this.configurationInstanceProvider);
    }

    private Object instantiateStaticConfiguration(MuleContext muleContext, ConfigurationObjectBuilder configurationObjectBuilder) {
        try {
            return configurationObjectBuilder.build(MuleExtensionUtils.getInitialiserEvent((MuleContext)muleContext));
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public ConfigurationInstanceProvider<Object> getObject() throws Exception {
        return this.configurationInstanceProvider;
    }

    public Class<ConfigurationInstanceProvider> getObjectType() {
        return ConfigurationInstanceProvider.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

