/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.capability.xml;

import org.custommonkey.xmlunit.XMLUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.registry.ServiceRegistry;
import org.mule.extension.introspection.Extension;
import org.mule.extension.introspection.ExtensionFactory;
import org.mule.extension.introspection.capability.XmlCapability;
import org.mule.extension.introspection.declaration.fluent.DeclarationDescriptor;
import org.mule.extension.introspection.declaration.fluent.Descriptor;
import org.mule.module.extension.HeisenbergExtension;
import org.mule.module.extension.internal.capability.xml.schema.SchemaGenerator;
import org.mule.module.extension.internal.introspection.AnnotationsBasedDescriber;
import org.mule.module.extension.internal.introspection.DefaultExtensionFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.util.IOUtils;

@SmallTest
public class SchemaGeneratorTestCase
extends AbstractMuleTestCase {
    private SchemaGenerator generator;
    private ExtensionFactory extensionFactory;

    @Before
    public void before() {
        this.generator = new SchemaGenerator();
        this.extensionFactory = new DefaultExtensionFactory((ServiceRegistry)Mockito.mock(ServiceRegistry.class));
    }

    @Test
    public void generate() throws Exception {
        String expectedSchema = IOUtils.getResourceAsString((String)"heisenberg.xsd", ((Object)((Object)this)).getClass());
        DeclarationDescriptor descriptor = new AnnotationsBasedDescriber(HeisenbergExtension.class).describe().getRootDeclaration();
        Extension extension = this.extensionFactory.createFrom((Descriptor)descriptor);
        XmlCapability capability = (XmlCapability)extension.getCapabilities(XmlCapability.class).iterator().next();
        String schema = this.generator.generate(extension, capability);
        System.out.println(schema);
        XMLUnit.setIgnoreWhitespace((boolean)true);
        Assert.assertThat((Object)XMLUnit.compareXML((String)expectedSchema, (String)schema).similar(), (Matcher)Is.is((Object)true));
    }
}

