/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal;

import java.math.BigDecimal;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.module.extension.HeisenbergExtension;
import org.mule.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.tck.junit4.ExtensionsFunctionalTestCase;

public class StatefulOperationTestCase
extends ExtensionsFunctionalTestCase {
    private static final String TENANT_1 = "heisenberg";
    private static final String TENANT_2 = "walter";
    private static final String STATIC_CONFIG = "staticHeisenberg";
    private static final String DYNAMIC_CONFIG = "heisenberg";

    protected Class<?>[] getAnnotatedExtensionClasses() {
        return new Class[]{HeisenbergExtension.class};
    }

    protected String getConfigFile() {
        return "heisenberg-stateful-operation-config.xml";
    }

    @Test
    public void stateOnOperationInstance() throws Exception {
        Assert.assertThat((Object)this.dynamicLaunder(), (Matcher)CoreMatchers.is((Object)40000L));
    }

    @Test
    public void stateOnDynamicConfigs() throws Exception {
        this.dynamicLaunder();
        this.assertRemainingMoney("heisenberg", "heisenberg", 70000L);
        this.assertRemainingMoney("heisenberg", TENANT_2, 90000L);
    }

    @Test
    public void stateOnStaticConfig() throws Exception {
        this.staticLounder(10000L);
        this.staticLounder(5000L);
        this.assertRemainingMoney(STATIC_CONFIG, "", 85000L);
    }

    private long dynamicLaunder() throws Exception {
        this.doDynamicLaunder("heisenberg", 30000L);
        return this.doDynamicLaunder(TENANT_2, 10000L);
    }

    private void assertRemainingMoney(String configName, String name, long expectedAmount) throws Exception {
        MuleEvent event = StatefulOperationTestCase.getTestEvent((Object)"");
        event.setFlowVariable("myName", (Object)name);
        HeisenbergExtension heisenbergExtension = (HeisenbergExtension)ExtensionsTestUtils.getConfigurationInstanceFromRegistry((String)configName, (MuleEvent)event);
        Assert.assertThat((Object)heisenbergExtension.getMoney(), (Matcher)CoreMatchers.equalTo((Object)BigDecimal.valueOf(expectedAmount)));
    }

    private long doDynamicLaunder(String name, long amount) throws Exception {
        MuleEvent event = StatefulOperationTestCase.getTestEvent((Object)amount);
        event.setFlowVariable("myName", (Object)name);
        return (Long)this.runFlow("laundry", event).getMessage().getPayload();
    }

    private long staticLounder(long amount) throws Exception {
        return (Long)this.runFlow("staticLaundry", StatefulOperationTestCase.getTestEvent((Object)amount)).getMessage().getPayload();
    }
}

