/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.extension.annotations.Extension;
import org.mule.extension.annotations.Operation;
import org.mule.extension.annotations.Operations;
import org.mule.extension.annotations.Parameter;
import org.mule.extension.annotations.capability.Xml;
import org.mule.extension.annotations.param.Optional;
import org.mule.extension.annotations.param.UseConfig;
import org.mule.tck.junit4.ExtensionsFunctionalTestCase;

public class ImplicitConfigTestCase
extends ExtensionsFunctionalTestCase {
    protected Class<?>[] getAnnotatedExtensionClasses() {
        return new Class[]{ImplicitConfigExtension.class};
    }

    protected String getConfigFile() {
        return "implicit-config.xml";
    }

    @Test
    public void getImplicitConfig() throws Exception {
        Integer defaultValue = 42;
        MuleEvent event = ImplicitConfigTestCase.getTestEvent((Object)"");
        event.setFlowVariable("optionalWithDefault", (Object)defaultValue);
        ImplicitConfigExtension config = (ImplicitConfigExtension)this.runFlow("implicitConfig", event).getMessage().getPayload();
        Assert.assertThat((Object)config, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)config.getMuleContext(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)muleContext)));
        Assert.assertThat((Object)config.getInitialise(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)config.getStart(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)config.getOptionalNoDefault(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)config.getOptionalWithDefault(), (Matcher)CoreMatchers.is((Object)defaultValue));
    }

    public static class ImplicitOperations {
        @Operation
        public ImplicitConfigExtension getConfig(@UseConfig ImplicitConfigExtension config) {
            return config;
        }
    }

    @Extension(name="implicit", version="1.0")
    @Operations(value={ImplicitOperations.class})
    @Xml(schemaLocation="http://www.mulesoft.org/schema/mule/implicit", namespace="implicit", schemaVersion="1.0")
    public static class ImplicitConfigExtension
    implements Initialisable,
    Startable,
    MuleContextAware {
        private MuleContext muleContext;
        private int initialise = 0;
        private int start = 0;
        @Parameter
        @Optional
        private String optionalNoDefault;
        @Parameter
        @Optional(defaultValue="#[flowVars['optionalWithDefault']]")
        private Integer optionalWithDefault;

        public void initialise() throws InitialisationException {
            ++this.initialise;
        }

        public void setMuleContext(MuleContext context) {
            this.muleContext = context;
        }

        public void start() throws MuleException {
            ++this.start;
        }

        public MuleContext getMuleContext() {
            return this.muleContext;
        }

        public int getInitialise() {
            return this.initialise;
        }

        public int getStart() {
            return this.start;
        }

        public String getOptionalNoDefault() {
            return this.optionalNoDefault;
        }

        public Integer getOptionalWithDefault() {
            return this.optionalWithDefault;
        }
    }
}

