/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.extension.ExtensionManager;
import org.mule.extension.introspection.Extension;
import org.mule.extension.runtime.ConfigurationInstanceProvider;
import org.mule.tck.junit4.ExtensionsFunctionalTestCase;

public class HeisenbergDefaultConfigTestCase
extends ExtensionsFunctionalTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    protected String getConfigFile() {
        return "heisenberg-default-config.xml";
    }

    @Test
    public void usesDefaultConfig() throws Exception {
        Assert.assertThat((Object)this.runFlow("sayMyName").getMessage().getPayloadAsString(), (Matcher)CoreMatchers.is((Object)"Heisenberg"));
    }

    @Test
    public void twoConfigsAndNoConfigRef() throws Exception {
        ExtensionManager extensionManager = muleContext.getExtensionManager();
        Extension extension = (Extension)extensionManager.getExtensions().iterator().next();
        Assert.assertThat((Object)extension.getName(), (Matcher)CoreMatchers.is((Object)"heisenberg"));
        ConfigurationInstanceProvider configurationInstanceProvider = (ConfigurationInstanceProvider)Mockito.mock(ConfigurationInstanceProvider.class);
        extensionManager.registerConfigurationInstanceProvider(extension, "secondConfig", configurationInstanceProvider);
        this.expectedException.expectCause(IsInstanceOf.instanceOf(IllegalStateException.class));
        this.runFlow("sayMyName");
    }
}

