/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEvent;
import org.mule.module.extension.HealthStatus;
import org.mule.module.extension.HeisenbergExtension;
import org.mule.module.extension.KnockeableDoor;
import org.mule.module.extension.Ricin;
import org.mule.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.tck.junit4.ExtensionsFunctionalTestCase;

@RunWith(value=Parameterized.class)
public class ConfigParserTestCase
extends ExtensionsFunctionalTestCase {
    private static final String HEISENBERG_BYNAME = "heisenberg";
    private static final String HEISENBERG_PLACEHOLDERS = "heisenbergWithPlaceHolders";
    private static final String HEISENBERG_BYREF = "heisenbergByRef";
    private static final String HEISENBERG_EXPRESSION = "expressionHeisenberg";
    private static final String HEISENBERG_EXPRESSION_BYREF = "expressionHeisenbergByRef";
    private static final Long MICROGRAMS_PER_KILO = 22L;
    private static final String LIDIA = "Lidia";
    private static final String STEVIA_COFFE_SHOP = "Stevia coffe shop";
    private static final String POLLOS_HERMANOS = "pollos hermanos";
    private static final String GUSTAVO_FRING = "Gustavo Fring";
    private static final String KRAZY_8 = "Krazy-8";
    private static final String JESSE_S = "Jesse's";
    private static final String METHYLAMINE = "methylamine";
    private static final int METHYLAMINE_QUANTITY = 75;
    private static final String PSEUDOEPHEDRINE = "pseudoephedrine";
    private static final int PSEUDOEPHEDRINE_QUANTITY = 0;
    private static final String P2P = "P2P";
    private static final int P2P_QUANTITY = 25;
    private static final String HANK = "Hank";
    private static final String MONEY = "1000000";
    private static final String SKYLER = "Skyler";
    private static final String SAUL = "Saul";
    private static final String WHITE_ADDRESS = "308 Negra Arroyo Lane";
    private static final String SHOPPING_MALL = "Shopping Mall";
    private static final int DEATH_YEAR = 2011;
    private static final HealthStatus INITIAL_HEALTH = HealthStatus.CANCER;
    private static final HealthStatus FINAL_HEALTH = HealthStatus.DEAD;
    @Parameterized.Parameter(value=0)
    public String testConfig;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({HEISENBERG_BYNAME}, {HEISENBERG_PLACEHOLDERS}, {HEISENBERG_BYREF}, {HEISENBERG_EXPRESSION}, {HEISENBERG_EXPRESSION_BYREF});
    }

    protected String getConfigFile() {
        return "heisenberg-config.xml";
    }

    protected Class<?>[] getAnnotatedExtensionClasses() {
        return new Class[]{HeisenbergExtension.class};
    }

    @Test
    public void config() throws Exception {
        HeisenbergExtension heisenberg = this.lookupHeisenberg(this.testConfig);
        this.assertHeisenbergConfig(heisenberg);
    }

    @Test
    public void sameInstanceForEquivalentEvent() throws Exception {
        MuleEvent event = this.getHeisenbergEvent();
        HeisenbergExtension heisenberg = this.lookupHeisenberg(this.testConfig, event);
        Assert.assertThat((Object)heisenberg, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.lookupHeisenberg(this.testConfig, event))));
    }

    @Test
    public void lifecycle() throws Exception {
        HeisenbergExtension heisenberg = this.lookupHeisenberg(this.testConfig);
        Assert.assertThat((Object)heisenberg.getInitialise(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)heisenberg.getStart(), (Matcher)CoreMatchers.is((Object)1));
        muleContext.stop();
        muleContext.dispose();
        Assert.assertThat((Object)heisenberg.getStop(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)heisenberg.getDispose(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void muleContextInjected() throws Exception {
        HeisenbergExtension heisenberg = this.lookupHeisenberg(this.testConfig);
        Assert.assertThat((Object)heisenberg.getMuleContext(), (Matcher)CoreMatchers.is((Object)muleContext));
    }

    @Test
    public void dependenciesInjected() throws Exception {
        HeisenbergExtension heisenberg = this.lookupHeisenberg(this.testConfig);
        Assert.assertThat((Object)heisenberg.getExtensionManager(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)muleContext.getExtensionManager())));
    }

    private HeisenbergExtension lookupHeisenberg(String key) throws Exception {
        return this.lookupHeisenberg(key, this.getHeisenbergEvent());
    }

    private HeisenbergExtension lookupHeisenberg(String key, MuleEvent event) throws Exception {
        return (HeisenbergExtension)ExtensionsTestUtils.getConfigurationInstanceFromRegistry((String)key, (MuleEvent)event);
    }

    private MuleEvent getHeisenbergEvent() throws Exception {
        MuleEvent event = ConfigParserTestCase.getTestEvent((Object)"");
        event.setFlowVariable("lidia", (Object)LIDIA);
        event.setFlowVariable("myName", (Object)"Heisenberg");
        event.setFlowVariable("age", (Object)"50");
        event.setFlowVariable("microgramsPerKilo", (Object)MICROGRAMS_PER_KILO);
        event.setFlowVariable("steviaCoffeShop", (Object)STEVIA_COFFE_SHOP);
        event.setFlowVariable("pollosHermanos", (Object)POLLOS_HERMANOS);
        event.setFlowVariable("gustavoFring", (Object)GUSTAVO_FRING);
        event.setFlowVariable("krazy8", (Object)KRAZY_8);
        event.setFlowVariable("jesses", (Object)JESSE_S);
        event.setFlowVariable(METHYLAMINE, (Object)75);
        event.setFlowVariable(PSEUDOEPHEDRINE, (Object)0);
        event.setFlowVariable("p2p", (Object)25);
        event.setFlowVariable("hank", (Object)HANK);
        event.setFlowVariable("money", (Object)MONEY);
        event.setFlowVariable("skyler", (Object)SKYLER);
        event.setFlowVariable("saul", (Object)SAUL);
        event.setFlowVariable("whiteAddress", (Object)WHITE_ADDRESS);
        event.setFlowVariable("shoppingMall", (Object)SHOPPING_MALL);
        event.setFlowVariable("initialHealth", (Object)INITIAL_HEALTH);
        event.setFlowVariable("finalHealth", (Object)FINAL_HEALTH);
        return event;
    }

    private void assertHeisenbergConfig(HeisenbergExtension heisenberg) {
        Assert.assertNotNull((Object)heisenberg);
        this.assertSimpleProperties(heisenberg);
        this.assertRecipe(heisenberg);
        this.assertDoors(heisenberg);
        this.assertRicinPacks(heisenberg);
        this.assertCandidateDoors(heisenberg);
    }

    private void assertRicinPacks(HeisenbergExtension heisenberg) {
        Set ricinPacks = heisenberg.getRicinPacks();
        Assert.assertNotNull((Object)ricinPacks);
        Assert.assertEquals((long)1L, (long)ricinPacks.size());
        Ricin ricin = (Ricin)ricinPacks.iterator().next();
        Assert.assertEquals((Object)MICROGRAMS_PER_KILO, (Object)ricin.getMicrogramsPerKilo());
        this.assertDoor(ricin.getDestination(), LIDIA, STEVIA_COFFE_SHOP);
    }

    private void assertDoors(HeisenbergExtension heisenberg) {
        KnockeableDoor door = heisenberg.getNextDoor();
        this.assertDoor(door, GUSTAVO_FRING, POLLOS_HERMANOS);
        KnockeableDoor previous = door.getPrevious();
        this.assertDoor(door.getPrevious(), KRAZY_8, JESSE_S);
        Assert.assertNull((Object)previous.getPrevious());
    }

    private void assertRecipe(HeisenbergExtension heisenberg) {
        Map recipe = heisenberg.getRecipe();
        Assert.assertNotNull((Object)recipe);
        Assert.assertEquals((long)3L, (long)recipe.size());
        Assert.assertEquals((Object)75L, recipe.get(METHYLAMINE));
        Assert.assertEquals((Object)0L, recipe.get(PSEUDOEPHEDRINE));
        Assert.assertEquals((Object)25L, recipe.get(P2P));
    }

    private void assertSimpleProperties(HeisenbergExtension heisenberg) {
        Assert.assertEquals((Object)"Heisenberg", (Object)heisenberg.getPersonalInfo().getName());
        Assert.assertEquals((Object)Integer.valueOf("50"), (Object)heisenberg.getPersonalInfo().getAge());
        List enemies = heisenberg.getEnemies();
        Assert.assertThat((Object)enemies, (Matcher)CoreMatchers.notNullValue());
        Assert.assertEquals((long)2L, (long)enemies.size());
        Assert.assertEquals((Object)GUSTAVO_FRING, enemies.get(0));
        Assert.assertEquals((Object)HANK, enemies.get(1));
        Assert.assertTrue((boolean)heisenberg.isCancer());
        Assert.assertThat((Object)heisenberg.getInitialHealth(), (Matcher)CoreMatchers.is((Object)INITIAL_HEALTH));
        Assert.assertThat((Object)heisenberg.getEndingHealth(), (Matcher)CoreMatchers.is((Object)FINAL_HEALTH));
        Calendar dayOfBirth = Calendar.getInstance();
        dayOfBirth.setTime(heisenberg.getPersonalInfo().getLifetimeInfo().getDateOfBirth());
        Assert.assertEquals((long)ConfigParserTestCase.getDateOfBirth().get(1), (long)dayOfBirth.get(1));
        Assert.assertEquals((long)ConfigParserTestCase.getDateOfDeath().get(1), (long)heisenberg.getPersonalInfo().getLifetimeInfo().getDateOfDeath().get(1));
        Assert.assertEquals((Object)new BigDecimal(MONEY), (Object)heisenberg.getMoney());
    }

    private void assertCandidateDoors(HeisenbergExtension heisenberg) {
        Map candidates = heisenberg.getCandidateDoors();
        Assert.assertNotNull((Object)candidates);
        Assert.assertEquals((long)2L, (long)candidates.size());
        this.assertDoor((KnockeableDoor)candidates.get(SKYLER.toLowerCase()), SKYLER, WHITE_ADDRESS);
        this.assertDoor((KnockeableDoor)candidates.get(SAUL.toLowerCase()), SAUL, SHOPPING_MALL);
    }

    private void assertDoor(KnockeableDoor door, String victim, String address) {
        Assert.assertNotNull((Object)door);
        Assert.assertEquals((Object)victim, (Object)door.getVictim());
        Assert.assertEquals((Object)address, (Object)door.getAddress());
    }

    public static Calendar getDateOfBirth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 1959);
        calendar.set(2, 8);
        calendar.set(5, 7);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public static Calendar getDateOfDeath() {
        Calendar calendar = ConfigParserTestCase.getDateOfBirth();
        calendar.set(1, 2011);
        return calendar;
    }
}

