/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.resources;

import java.util.HashSet;
import javax.annotation.processing.ProcessingEnvironment;
import junit.framework.Assert;
import org.apache.commons.lang.StringUtils;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.api.registry.ServiceRegistry;
import org.mule.extension.introspection.Extension;
import org.mule.extension.introspection.capability.XmlCapability;
import org.mule.extension.resources.GenerableResource;
import org.mule.extension.resources.ResourcesGenerator;
import org.mule.module.extension.internal.capability.xml.ImmutableXmlCapability;
import org.mule.module.extension.internal.capability.xml.SpringBundleResourceContributor;
import org.mule.module.extension.internal.config.ExtensionsNamespaceHandler;
import org.mule.module.extension.internal.resources.AnnotationProcessorResourceGenerator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class SpringBundleResourceContributorTestCase
extends AbstractMuleTestCase {
    private static final String EXTENSION_NAME = "extension";
    private static final String EXTENSION_VERSION = "version";
    private static final String SCHEMA_LOCATION = "mulesoft.com/extension";
    private static final String UNSCAPED_LOCATION_PREFIX = "http://";
    private static final String ESCAPED_LOCATION_PREFIX = "http\\://";
    private static final String SCHEMA_NAME = "mule-extension.xsd";
    @Mock
    private Extension extension;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ServiceRegistry serviceRegistry;
    private ResourcesGenerator generator;
    private XmlCapability xmlCapability;
    private SpringBundleResourceContributor contributor;

    @Before
    public void before() {
        this.xmlCapability = new ImmutableXmlCapability(EXTENSION_VERSION, "test", "http://mulesoft.com/extension");
        HashSet<XmlCapability> capabilities = new HashSet<XmlCapability>();
        capabilities.add(this.xmlCapability);
        Mockito.when((Object)this.extension.getCapabilities(XmlCapability.class)).thenReturn(capabilities);
        this.generator = new AnnotationProcessorResourceGenerator((ProcessingEnvironment)Mockito.mock(ProcessingEnvironment.class), this.serviceRegistry);
        Mockito.when((Object)this.extension.getName()).thenReturn((Object)EXTENSION_NAME);
        Mockito.when((Object)this.extension.getVersion()).thenReturn((Object)EXTENSION_VERSION);
        this.contributor = new SpringBundleResourceContributor();
    }

    @Test
    public void generateSchema() {
        this.contributor.contribute(this.extension, this.generator);
        GenerableResource resource = this.generator.getOrCreateResource(SCHEMA_NAME);
        Assert.assertNotNull((Object)resource);
        Assert.assertFalse((boolean)StringUtils.isBlank((String)resource.getContentBuilder().toString()));
    }

    @Test
    public void springHandlers() {
        this.contributor.contribute(this.extension, this.generator);
        GenerableResource resource = this.generator.getOrCreateResource("spring.handlers");
        Assert.assertNotNull((Object)resource);
        Assert.assertEquals((String)String.format("%s=%s", "http\\://mulesoft.com/extension", ExtensionsNamespaceHandler.class.getName()), (String)resource.getContentBuilder().toString());
    }

    @Test
    public void springSchemas() {
        this.contributor.contribute(this.extension, this.generator);
        GenerableResource resource = this.generator.getOrCreateResource("spring.schemas");
        Assert.assertNotNull((Object)resource);
        StringBuilder expected = new StringBuilder();
        expected.append(String.format("%s/%s/%s=META-INF/%s\n", "http\\://mulesoft.com/extension", EXTENSION_VERSION, SCHEMA_NAME, SCHEMA_NAME));
        expected.append(String.format("%s/current/%s=META-INF/%s\n", "http\\://mulesoft.com/extension", SCHEMA_NAME, SCHEMA_NAME));
        Assert.assertEquals((String)expected.toString(), (String)resource.getContentBuilder().toString());
    }
}

