/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.capability.xml;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.extension.annotations.capability.Xml;
import org.mule.extension.introspection.capability.XmlCapability;
import org.mule.extension.introspection.declaration.DeclarationConstruct;
import org.mule.extension.introspection.declaration.HasCapabilities;
import org.mule.module.extension.internal.introspection.AbstractCapabilitiesExtractorContractTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class XmlCapabilityExtractorTestCase
extends AbstractCapabilitiesExtractorContractTestCase {
    private static final String SCHEMA_VERSION = "SCHEMA_VERSION";
    private static final String NAMESPACE = "NAMESPACE";
    private static final String SCHEMA_LOCATION = "SCHEMA_LOCATION";
    private static final String EXTENSION_NAME = "extension";
    private static final String EXTENSION_VERSION = "3.7";
    private ArgumentCaptor<XmlCapability> captor;

    @Before
    public void before() {
        super.before();
        this.captor = ArgumentCaptor.forClass(XmlCapability.class);
    }

    @Test
    public void capabilityAdded() {
        this.resolver.resolveCapabilities(this.declarationConstruct, XmlSupport.class, this.capabilitiesCallback);
        ((HasCapabilities)Mockito.verify((Object)this.capabilitiesCallback)).withCapability(this.captor.capture());
        XmlCapability capability = (XmlCapability)this.captor.getValue();
        Assert.assertThat((Object)capability, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)capability.getSchemaVersion(), (Matcher)CoreMatchers.is((Object)SCHEMA_VERSION));
        Assert.assertThat((Object)capability.getNamespace(), (Matcher)CoreMatchers.is((Object)NAMESPACE));
        Assert.assertThat((Object)capability.getSchemaLocation(), (Matcher)CoreMatchers.is((Object)SCHEMA_LOCATION));
    }

    @Test
    public void defaultCapabilityValues() {
        this.declarationConstruct = new DeclarationConstruct(EXTENSION_NAME, EXTENSION_VERSION);
        this.resolver.resolveCapabilities(this.declarationConstruct, DefaultXmlExtension.class, this.capabilitiesCallback);
        ((HasCapabilities)Mockito.verify((Object)this.capabilitiesCallback)).withCapability(this.captor.capture());
        XmlCapability capability = (XmlCapability)this.captor.getValue();
        Assert.assertThat((Object)capability, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)capability.getSchemaVersion(), (Matcher)CoreMatchers.is((Object)EXTENSION_VERSION));
        Assert.assertThat((Object)capability.getNamespace(), (Matcher)CoreMatchers.is((Object)NAMESPACE));
        Assert.assertThat((Object)capability.getSchemaLocation(), (Matcher)CoreMatchers.equalTo((Object)String.format("http://www.mulesoft.org/schema/mule/extension/%s", EXTENSION_NAME)));
    }

    @Xml(namespace="NAMESPACE")
    private static class DefaultXmlExtension {
        private DefaultXmlExtension() {
        }
    }

    @Xml(schemaVersion="SCHEMA_VERSION", namespace="NAMESPACE", schemaLocation="SCHEMA_LOCATION")
    private static class XmlSupport {
        private XmlSupport() {
        }
    }
}

