/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.capability.xml;

import com.google.common.io.ByteSource;
import com.google.common.truth.SubjectFactory;
import com.google.common.truth.Truth;
import com.google.testing.compile.CompileTester;
import com.google.testing.compile.JavaFileObjects;
import com.google.testing.compile.JavaSourcesSubject;
import com.google.testing.compile.JavaSourcesSubjectFactory;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import javax.annotation.processing.Processor;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import net.sf.saxon.xpath.XPathFactoryImpl;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mule.module.extension.internal.resources.ExtensionResourcesGeneratorAnnotationProcessor;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.util.IOUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

@SmallTest
public class ExtensionResourcesGeneratorAnnotationProcessorTestCase
extends AbstractMuleTestCase {
    private static final String GROUP_PARAMETER_1 = "Group parameter 1";
    private static final String GROUP_PARAMETER_2 = "Group parameter 2";
    private XPath xpath;
    private DocumentBuilderFactory builderFactory;

    @Before
    public void before() throws Exception {
        XPathFactoryImpl xpathFactory = new XPathFactoryImpl();
        this.xpath = xpathFactory.newXPath();
        this.builderFactory = DocumentBuilderFactory.newInstance();
        this.builderFactory.setNamespaceAware(true);
    }

    @Test
    public void generateDocumentedSchema() throws Exception {
        ArgumentCaptor byteSourceCaptor = ArgumentCaptor.forClass(ByteSource.class);
        ByteSource byteSource = (ByteSource)Mockito.mock(ByteSource.class);
        Mockito.when((Object)byteSource.contentEquals((ByteSource)byteSourceCaptor.capture())).thenReturn((Object)true);
        ((CompileTester.GeneratedPredicateClause)((JavaSourcesSubject)Truth.assert_().about((SubjectFactory)JavaSourcesSubjectFactory.javaSources()).that(this.testSourceFiles())).processedWith((Processor)new ExtensionResourcesGeneratorAnnotationProcessor(), new Processor[0]).compilesWithoutError().and()).generatesFileNamed((JavaFileManager.Location)StandardLocation.SOURCE_OUTPUT, "", "mule-documentation.xsd").withContents(byteSource);
        ByteSource generatedByteSource = (ByteSource)byteSourceCaptor.getValue();
        Assert.assertThat((Object)generatedByteSource, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        String generatedSchema = IOUtils.toString((InputStream)generatedByteSource.openStream());
        this.assertXpath(generatedSchema, "//xs:attribute[@name='configParameter']/xs:annotation/xs:documentation", "Config parameter");
        this.assertXpath(generatedSchema, "//xs:attribute[@name='value1']/xs:annotation/xs:documentation", GROUP_PARAMETER_1);
        this.assertXpath(generatedSchema, "//xs:attribute[@name='value2']/xs:annotation/xs:documentation", GROUP_PARAMETER_2);
        this.assertXpath(generatedSchema, "//xs:element[@name='operation']/xs:annotation/xs:documentation", "Test Operation");
        this.assertXpath(generatedSchema, "//xs:complexType[@name='OperationType']/xs:complexContent/xs:extension/xs:attribute[@name='value']/xs:annotation/xs:documentation", "test value");
        this.assertXpath(generatedSchema, "//xs:complexType[@name='OperationType']/xs:complexContent/xs:extension/xs:attribute[@name='value1']/xs:annotation/xs:documentation", GROUP_PARAMETER_1);
        this.assertXpath(generatedSchema, "//xs:complexType[@name='OperationType']/xs:complexContent/xs:extension/xs:attribute[@name='value2']/xs:annotation/xs:documentation", GROUP_PARAMETER_2);
    }

    private void assertXpath(String input, String expression, String expected) throws Exception {
        Assert.assertThat((Object)this.xpath(input, expression), (Matcher)CoreMatchers.is((Object)expected));
    }

    private String xpath(String input, String expression) throws Exception {
        Document node = this.builderFactory.newDocumentBuilder().parse(new InputSource(new StringReader(input)));
        return (String)this.xpath.evaluate(expression, node, XPathConstants.STRING);
    }

    private Iterable<JavaFileObject> testSourceFiles() throws Exception {
        File folder = new File(((Object)((Object)this)).getClass().getClassLoader().getResource("").getPath().toString());
        folder = folder.getParentFile().getParentFile();
        folder = new File(folder, "src/test/java/" + ((Object)((Object)this)).getClass().getPackage().getName().replaceAll("\\.", "/"));
        File[] files = folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".java");
            }
        });
        ArrayList<JavaFileObject> javaFileObjects = new ArrayList<JavaFileObject>(files.length);
        for (File file : files) {
            javaFileObjects.add(JavaFileObjects.forResource((URL)file.toURI().toURL()));
        }
        return javaFileObjects;
    }
}

