/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal;

import java.math.BigDecimal;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.module.extension.HeisenbergExtension;
import org.mule.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.tck.junit4.ExtensionsFunctionalTestCase;

public class StatefulOperationTestCase
extends ExtensionsFunctionalTestCase {
    protected Class<?>[] getAnnotatedExtensionClasses() {
        return new Class[]{HeisenbergExtension.class};
    }

    protected String getConfigFile() {
        return "heisenberg-stateful-operation-config.xml";
    }

    @Test
    public void statefulOperation() throws Exception {
        String dynamicConfig1 = "heisenberg";
        this.doLaunder("heisenberg", 10000L);
        long totalLaunderedAmountForConfig1 = this.doLaunder("heisenberg", 20000L);
        String dynamicConfig2 = "walter";
        this.doLaunder("walter", 30000L);
        long totalLaunderedAmountForConfig2 = this.doLaunder("walter", 30000L);
        Assert.assertThat((Object)totalLaunderedAmountForConfig1, (Matcher)CoreMatchers.is((Object)30000L));
        Assert.assertThat((Object)totalLaunderedAmountForConfig2, (Matcher)CoreMatchers.is((Object)60000L));
        this.assertRemainingMoney("heisenberg", 70000L);
        this.assertRemainingMoney("walter", 40000L);
    }

    private void assertRemainingMoney(String name, long expectedAmount) throws Exception {
        MuleEvent event = StatefulOperationTestCase.getTestEvent((Object)"");
        event.setFlowVariable("myName", (Object)name);
        HeisenbergExtension heisenbergExtension = (HeisenbergExtension)ExtensionsTestUtils.getConfigurationInstance((String)"heisenberg", (MuleEvent)event);
        Assert.assertThat((Object)heisenbergExtension.getMoney(), (Matcher)CoreMatchers.equalTo((Object)BigDecimal.valueOf(expectedAmount)));
    }

    private long doLaunder(String name, long amount) throws Exception {
        MuleEvent event = StatefulOperationTestCase.getTestEvent((Object)amount);
        event.setFlowVariable("myName", (Object)name);
        return (Long)this.runFlow("laundry", event).getMessage().getPayload();
    }
}

