/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.extension.ExtensionManager;
import org.mule.module.extension.HealthStatus;
import org.mule.module.extension.HeisenbergExtension;
import org.mule.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.tck.junit4.ExtensionsFunctionalTestCase;

public class OperationExecutionTestCase
extends ExtensionsFunctionalTestCase {
    private static final String GUSTAVO_FRING = "Gustavo Fring";
    private static final String SECRET_PACKAGE = "secretPackage";
    private static final String METH = "meth";
    private static final String GOODBYE_MESSAGE = "Say hello to my little friend";
    private static final String VICTIM = "Skyler";

    protected Class<?>[] getAnnotatedExtensionClasses() {
        return new Class[]{HeisenbergExtension.class};
    }

    protected String getConfigFile() {
        return "heisenberg-operation-config.xml";
    }

    @Test
    public void operationWithReturnValueAndWithoutParameters() throws Exception {
        this.runFlowAndExpect("sayMyName", "Heisenberg");
    }

    @Test
    public void voidOperationWithoutParameters() throws Exception {
        MuleEvent originalEvent = OperationExecutionTestCase.getTestEvent((Object)"");
        MuleEvent responseEvent = this.runFlow("die", originalEvent);
        Assert.assertThat((Object)responseEvent.getMessageAsString(), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)this.getConfig("heisenberg").getEndingHealth(), (Matcher)CoreMatchers.is((Object)HealthStatus.DEAD));
    }

    @Test
    public void operationWithFixedParameter() throws Exception {
        this.runFlowAndExpect("getFixedEnemy", GUSTAVO_FRING);
    }

    @Test
    public void operationWithDynamicParameter() throws Exception {
        this.doTestExpressionEnemy(0);
    }

    @Test
    public void operationWithTransformedParameter() throws Exception {
        this.doTestExpressionEnemy("0");
    }

    @Test
    public void operationWithInjectedEvent() throws Exception {
        MuleEvent event = OperationExecutionTestCase.getTestEvent((Object)"");
        event = this.runFlow("hideInEvent", event);
        Assert.assertThat((Object)((String)event.getFlowVariable(SECRET_PACKAGE)), (Matcher)CoreMatchers.is((Object)METH));
    }

    @Test
    public void operationWithInjectedMessage() throws Exception {
        MuleEvent event = OperationExecutionTestCase.getTestEvent((Object)"");
        this.runFlow("hideInMessage", event);
        Assert.assertThat((Object)((String)event.getMessage().getInvocationProperty(SECRET_PACKAGE)), (Matcher)CoreMatchers.is((Object)METH));
    }

    @Test
    public void parameterFixedAtPayload() throws Exception {
        this.assertKillByPayload("killFromPayload");
    }

    @Test
    public void optionalParameterDefaultingToPayload() throws Exception {
        this.assertKillByPayload("customKillWithDefault");
    }

    @Test
    public void optionalParameterWithDefaultOverride() throws Exception {
        MuleEvent event = OperationExecutionTestCase.getTestEvent((Object)"");
        event.setFlowVariable("goodbye", (Object)GOODBYE_MESSAGE);
        event.setFlowVariable("victim", (Object)VICTIM);
        event = this.runFlow("customKillWithoutDefault", event);
        this.assertKillPayload(event);
    }

    @Test
    public void oneNestedOperation() throws Exception {
        MuleEvent event = this.runFlow("killOne");
        String expected = "Killed the following because I'm the one who knocks:\nbye bye, Gustavo Fring\n";
        Assert.assertThat((Object)expected, (Matcher)CoreMatchers.is((Object)event.getMessageAsString()));
    }

    @Test
    public void manyNestedOperations() throws Exception {
        MuleEvent event = this.runFlow("killMany");
        String expected = "Killed the following because I'm the one who knocks:\nbye bye, Gustavo Fring\nbye bye, Frank\nbye bye, Nazi dudes\n";
        Assert.assertThat((Object)expected, (Matcher)CoreMatchers.is((Object)event.getMessageAsString()));
    }

    @Test
    public void manyNestedOperationsSupportedButOnlyOneProvided() throws Exception {
        MuleEvent event = this.runFlow("killManyButOnlyOneProvided");
        String expected = "Killed the following because I'm the one who knocks:\nbye bye, Gustavo Fring\n";
        Assert.assertThat((Object)expected, (Matcher)CoreMatchers.is((Object)event.getMessageAsString()));
    }

    @Test
    public void getInjectedDependency() throws Exception {
        ExtensionManager extensionManager = (ExtensionManager)this.runFlow("injectedExtensionManager").getMessage().getPayload();
        Assert.assertThat((Object)extensionManager, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)muleContext.getExtensionManager())));
    }

    @Test
    public void alias() throws Exception {
        String alias = this.runFlow("alias").getMessageAsString();
        Assert.assertThat((Object)alias, (Matcher)CoreMatchers.is((Object)"Howdy!, my name is Walter White and I'm 52 years old"));
    }

    private void assertKillPayload(MuleEvent event) throws MuleException {
        Assert.assertThat((Object)event.getMessageAsString(), (Matcher)CoreMatchers.is((Object)String.format("%s, %s", GOODBYE_MESSAGE, VICTIM)));
    }

    private void assertKillByPayload(String flowName) throws Exception {
        MuleEvent event = OperationExecutionTestCase.getTestEvent((Object)VICTIM);
        event.setFlowVariable("goodbye", (Object)GOODBYE_MESSAGE);
        event = this.runFlow(flowName, event);
        this.assertKillPayload(event);
    }

    private void doTestExpressionEnemy(Object enemyIndex) throws Exception {
        MuleEvent event = OperationExecutionTestCase.getTestEvent((Object)"");
        event.setFlowVariable("enemy", enemyIndex);
        event = this.runFlow("expressionEnemy", event);
        Assert.assertThat((Object)event.getMessageAsString(), (Matcher)CoreMatchers.is((Object)GUSTAVO_FRING));
    }

    private HeisenbergExtension getConfig(String name) throws Exception {
        return (HeisenbergExtension)ExtensionsTestUtils.getConfigurationInstance((String)name, (MuleEvent)OperationExecutionTestCase.getTestEvent((Object)""));
    }
}

