/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal;

import javax.inject.Inject;
import javax.inject.Named;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.extension.runtime.ConfigurationInstanceProvider;
import org.mule.module.extension.HeisenbergExtension;
import org.mule.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.tck.junit4.ExtensionsFunctionalTestCase;

public class ExtensionsAsInjectedDependenciesTestCase
extends ExtensionsFunctionalTestCase {
    private static final String STATIC_HEISENBERG = "staticHeisenberg";
    private static final String DYNAMIC_AGE_HEISENBERG = "dynamicAgeHeisenberg";
    private Dependent dependent;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.dependent = (Dependent)muleContext.getInjector().inject((Object)new Dependent());
    }

    protected String getConfigFile() {
        return "heisenberg-injected.xml";
    }

    protected Class<?>[] getAnnotatedExtensionClasses() {
        return new Class[]{HeisenbergExtension.class};
    }

    @Test
    public void staticHeisenbergWasInjected() throws Exception {
        this.assertCorrectProviderInjected(STATIC_HEISENBERG, this.dependent.getStaticHeisenberg());
        HeisenbergExtension heisenberg = (HeisenbergExtension)ExtensionsTestUtils.getConfigurationInstance((String)STATIC_HEISENBERG, (MuleEvent)ExtensionsAsInjectedDependenciesTestCase.getTestEvent((Object)""));
        Assert.assertThat((Object)heisenberg.getPersonalInfo().getAge(), (Matcher)CoreMatchers.is((Object)50));
    }

    @Test
    public void dynamicHeisenbergWasInjected() throws Exception {
        this.assertCorrectProviderInjected(DYNAMIC_AGE_HEISENBERG, this.dependent.getDynamicAgeHeisenberg());
        int age = 52;
        MuleEvent event = ExtensionsAsInjectedDependenciesTestCase.getTestEvent((Object)"");
        event.setFlowVariable("age", (Object)52);
        HeisenbergExtension heisenberg = (HeisenbergExtension)ExtensionsTestUtils.getConfigurationInstance((String)DYNAMIC_AGE_HEISENBERG, (MuleEvent)event);
        Assert.assertThat((Object)heisenberg.getPersonalInfo().getAge(), (Matcher)CoreMatchers.is((Object)52));
    }

    private void assertCorrectProviderInjected(String key, ConfigurationInstanceProvider<?> expected) {
        Assert.assertThat(expected, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)muleContext.getRegistry().get(key))));
    }

    public static class Dependent {
        @Inject
        @Named(value="staticHeisenberg")
        private ConfigurationInstanceProvider<HeisenbergExtension> staticHeisenberg;
        @Inject
        @Named(value="dynamicAgeHeisenberg")
        private ConfigurationInstanceProvider<HeisenbergExtension> dynamicAgeHeisenberg;

        public ConfigurationInstanceProvider<HeisenbergExtension> getStaticHeisenberg() {
            return this.staticHeisenberg;
        }

        public ConfigurationInstanceProvider<HeisenbergExtension> getDynamicAgeHeisenberg() {
            return this.dynamicAgeHeisenberg;
        }
    }
}

