/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth.processor;

import java.lang.reflect.Type;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.callback.HttpCallback;
import org.mule.api.callback.HttpCallbackFactory;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.InterceptingMessageProcessor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.devkit.processor.DevkitBasedMessageProcessor;
import org.mule.module.http.internal.config.HttpConfiguration;
import org.mule.security.oauth.callback.DefaultHttpCallbackFactory;
import org.mule.security.oauth.callback.HttpCallbackAdapter;
import org.mule.security.oauth.notification.OAuthAuthorizeNotification;
import org.mule.security.oauth.processor.FetchAccessTokenMessageProcessor;

public abstract class AbstractAuthorizeMessageProcessor
extends DevkitBasedMessageProcessor
implements FlowConstructAware,
MuleContextAware,
Initialisable,
Startable,
Stoppable,
InterceptingMessageProcessor {
    private MessageProcessor listener;
    private String authorizationUrl = null;
    private String accessTokenUrl = null;
    private HttpCallback oauthCallback;
    private String state;
    protected HttpCallbackFactory callbackFactory;

    public AbstractAuthorizeMessageProcessor() {
        super("authorize");
    }

    protected abstract String getAuthCodeRegex();

    @Override
    public void start() throws MuleException {
        if (this.callbackFactory == null) {
            this.callbackFactory = new DefaultHttpCallbackFactory();
            this.callbackFactory.forceOldHttpTransport(HttpConfiguration.useTransportForUris((MuleContext)this.muleContext));
        }
    }

    protected void startCallback(HttpCallbackAdapter adapter, FetchAccessTokenMessageProcessor fetchAccessTokenMessageProcessor) throws MuleException {
        if (this.oauthCallback == null) {
            this.oauthCallback = this.callbackFactory.createCallback(adapter, this.getAuthCodeRegex(), fetchAccessTokenMessageProcessor, this.listener, this.muleContext, this.flowConstruct);
            this.oauthCallback.start();
        }
        fetchAccessTokenMessageProcessor.setRedirectUri(this.oauthCallback.getUrl());
    }

    protected void notifyAuthorizeStart(MuleEvent event) {
        this.muleContext.fireNotification((ServerNotification)new OAuthAuthorizeNotification(event, 400001));
    }

    @Override
    public final void stop() throws MuleException {
        if (this.oauthCallback != null) {
            this.oauthCallback.stop();
        }
    }

    protected String toString(MuleEvent event, Object value) {
        try {
            return (String)this.evaluateAndTransform(this.getMuleContext(), event, (Type)((Object)String.class), null, value);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerMessagingException e) {
            throw new RuntimeException(e);
        }
    }

    public void setListener(MessageProcessor value) {
        this.listener = value;
    }

    public void setAuthorizationUrl(String value) {
        this.authorizationUrl = value;
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public void setAccessTokenUrl(String value) {
        this.accessTokenUrl = value;
    }

    public String getAccessTokenUrl() {
        return this.accessTokenUrl;
    }

    public void setState(String value) {
        this.state = value;
    }

    public HttpCallback getOauthCallback() {
        return this.oauthCallback;
    }

    public void setOauthCallback(HttpCallback oauthCallback) {
        this.oauthCallback = oauthCallback;
    }

    public MessageProcessor getListener() {
        return this.listener;
    }

    public String getState() {
        return this.state;
    }

    public void setCallbackFactory(HttpCallbackFactory callbackFactory) {
        this.callbackFactory = callbackFactory;
    }
}

