/*
 * Decompiled with CFR 0.152.
 */
package org.mule.streaming.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.security.oauth.callback.ProcessCallback;
import org.mule.streaming.ProviderAwarePagingDelegate;
import org.mule.streaming.processor.ManagedPagingDelegateAdapter;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ManagedPagingDelegateAdapterTestCase {
    @Mock
    private ProviderAwarePagingDelegate<String, Object> pagingDelegate;
    @Mock
    private MuleEvent event;
    @Mock
    private MessageProcessor messageProcessor;
    private ProcessTemplate<Object, Object> template;
    private List<String> page = Arrays.asList("hello", "world");
    private List<Class<? extends Exception>> managedExceptions;
    private Object provider = new Object();
    private ManagedPagingDelegateAdapter<String> managedPagingDelegate;

    @Before
    public void doSetup() throws Exception {
        Mockito.when((Object)this.pagingDelegate.getPage(this.provider)).thenReturn(this.page);
        Mockito.when((Object)this.pagingDelegate.getTotalResults(this.provider)).thenReturn((Object)this.page.size());
        this.managedExceptions = new ArrayList<Class<? extends Exception>>();
        this.managedExceptions.add(UnsupportedOperationException.class);
        this.template = new ProcessTemplate<Object, Object>(){

            public Object execute(ProcessCallback<Object, Object> callback, MessageProcessor messageProcessor, MuleEvent event) throws Exception {
                return callback.process(ManagedPagingDelegateAdapterTestCase.this.provider);
            }

            public Object execute(ProcessCallback<Object, Object> callback, Filter filter, MuleMessage message) throws Exception {
                return callback.process(ManagedPagingDelegateAdapterTestCase.this.provider);
            }
        };
        this.managedPagingDelegate = new ManagedPagingDelegateAdapter(this.pagingDelegate, this.template, this.managedExceptions, true, this.messageProcessor, this.event);
    }

    @Test
    public void getPage() throws Exception {
        Assert.assertSame(this.page, (Object)this.managedPagingDelegate.getPage());
        ((ProviderAwarePagingDelegate)Mockito.verify(this.pagingDelegate)).getPage(this.provider);
    }

    @Test
    public void getTotalResults() throws Exception {
        Assert.assertEquals((long)this.page.size(), (long)this.managedPagingDelegate.getTotalResults());
        ((ProviderAwarePagingDelegate)Mockito.verify(this.pagingDelegate)).getTotalResults(this.provider);
    }
}

