/*
 * Decompiled with CFR 0.152.
 */
package org.mule.streaming.processor;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.streaming.ConsumerIterator;
import org.mule.streaming.PagingConfiguration;
import org.mule.streaming.PagingDelegate;
import org.mule.streaming.processor.AbstractDevkitBasedPageableMessageProcessor;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DevkitBasedPagingMessageProcessorTestCase {
    private static final String PAGE_SIZE = "100";
    private static final int TOP = 1000;
    private MuleEvent event;
    private MuleContext muleContext;

    @Before
    public void setUp() {
        this.muleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.event = (MuleEvent)Mockito.mock(MuleEvent.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.event.getMuleContext()).thenReturn((Object)this.muleContext);
    }

    @Test
    public void elementBasedIteratior() throws Exception {
        TestPagingProcessor processor = this.newProcessor();
        ArgumentCaptor captor = ArgumentCaptor.forClass(ConsumerIterator.class);
        processor.process(this.event);
        ((MuleMessage)Mockito.verify((Object)this.event.getMessage())).setPayload(captor.capture());
        ConsumerIterator it = (ConsumerIterator)captor.getValue();
        for (int i = 0; i < 1000; ++i) {
            Assert.assertTrue((boolean)it.hasNext());
            Assert.assertNotNull((Object)it.next());
        }
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test(expected=MuleException.class)
    public void nullDelegate() throws Exception {
        TestPagingProcessor processor = (TestPagingProcessor)((Object)Mockito.spy((Object)((Object)this.newProcessor())));
        ((TestPagingProcessor)((Object)Mockito.doReturn(null).when((Object)processor))).getPagingDelegate((MuleEvent)Mockito.any(MuleEvent.class), (PagingConfiguration)Mockito.any(PagingConfiguration.class));
        processor.process(this.event);
    }

    @Test(expected=MessagingException.class)
    public void invalidFetchSize() throws Exception {
        TestPagingProcessor processor = this.newProcessor();
        processor.setFetchSize("0");
        processor.process(this.event);
    }

    private TestPagingProcessor newProcessor() {
        TestPagingProcessor processor = new TestPagingProcessor();
        processor.setMuleContext(this.muleContext);
        processor.setFetchSize(PAGE_SIZE);
        return processor;
    }

    private class TestPagingProcessor
    extends AbstractDevkitBasedPageableMessageProcessor {
        private TestPagingProcessor() {
            super("paging-test");
        }

        protected PagingDelegate<?> getPagingDelegate(MuleEvent event, PagingConfiguration pagingConfiguration) {
            this.assertPagingConfiguration(pagingConfiguration);
            return new PagingDelegate<String>(){
                long counter = 0L;

                public List<String> getPage() {
                    if (this.counter < 1000L) {
                        ArrayList<String> page = new ArrayList<String>(100);
                        for (int i = 0; i < Integer.valueOf(DevkitBasedPagingMessageProcessorTestCase.PAGE_SIZE); ++i) {
                            ++this.counter;
                            String value = RandomStringUtils.randomAlphabetic((int)5000);
                            page.add(value);
                        }
                        return page;
                    }
                    return null;
                }

                public void close() throws MuleException {
                }

                public int getTotalResults() {
                    return 1000;
                }
            };
        }

        private void assertPagingConfiguration(PagingConfiguration config) {
            Assert.assertEquals((long)config.getFetchSize(), (long)Integer.valueOf(DevkitBasedPagingMessageProcessorTestCase.PAGE_SIZE).intValue());
        }

        protected Object evaluateAndTransform(MuleContext muleContext, MuleEvent event, Type expectedType, String expectedMimeType, Object source) throws TransformerException, TransformerMessagingException {
            if (Integer.class.equals((Object)expectedType) && source instanceof String) {
                return Integer.valueOf((String)source);
            }
            return super.evaluateAndTransform(muleContext, event, expectedType, expectedMimeType, source);
        }
    }
}

