/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.security.oauth.util.HttpUtil;
import org.mule.security.oauth.util.HttpUtilImpl;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

@RunWith(value=Parameterized.class)
public class HttpUtilTestCase
extends FunctionalTestCase {
    private static final String SUCCESS_PAYLOAD = "ok";
    private int statusCode;
    private final HttpUtil util = new HttpUtilImpl();
    @Rule
    public DynamicPort port = new DynamicPort("port1");

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({200}, {201}, {202}, {203}, {500});
    }

    public HttpUtilTestCase(int statusCode) {
        this.statusCode = statusCode;
    }

    protected String getConfigFile() {
        return "http-util-config.xml";
    }

    @Test
    public void testResponse() throws Exception {
        try {
            Assert.assertEquals((String)SUCCESS_PAYLOAD, (String)this.util.post(String.format("http://localhost:%d/%d", this.port.getNumber(), this.statusCode), ""));
            Assert.assertFalse((this.statusCode == 500 ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            Assert.assertEquals((int)500, (int)this.statusCode);
            Assert.assertTrue((boolean)(e.getCause() instanceof IOException));
        }
    }
}

