/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth.util;

import junit.framework.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.security.oauth.util.HttpUtil;
import org.mule.security.oauth.util.HttpUtilImpl;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.StringUtils;

public class HttpUtilEchoTestCase
extends FunctionalTestCase {
    private static final String SMALL_PAYLOAD = "This is a test.";
    private static final String BIG_PAYLOAD = StringUtils.repeat((String)"This is a test.", (int)100);
    private final HttpUtil util = new HttpUtilImpl();
    @Rule
    public DynamicPort port = new DynamicPort("port1");

    protected String getConfigFile() {
        return "http-util-config.xml";
    }

    @Test
    public void testSmallPayload() throws Exception {
        this.postAndAssert(SMALL_PAYLOAD);
    }

    @Test
    public void testBigPayload() throws Exception {
        this.postAndAssert(BIG_PAYLOAD);
    }

    private void postAndAssert(String payload) {
        Assert.assertEquals((String)payload, (String)this.util.post(String.format("http://localhost:%d/echo", this.port.getNumber()), payload));
    }
}

