/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth.util;

import java.util.Date;
import java.util.regex.Pattern;
import junit.framework.Assert;
import org.junit.Test;
import org.mule.security.oauth.util.DefaultOAuthResponseParser;
import org.mule.security.oauth.util.OAuthResponseParser;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DefaultOAuthResponseParserTestCase {
    private static final String response = "{\n\"access_token\" : \"ya29.AHES6ZTtm7SuokEB-RGtbBty9IIlNiP9-eNMMQKtXdMP3sfjL1Fc\"\n,\"token_type\" : \"Bearer\",\n\"expires_in\" : 3600,\n\"refresh_token\" : \"1/HKSmLFXzqP0leUihZp2xUt3-5wkU7Gmu2Os_eBnzw74\"\n}";
    private static final Pattern ACCESS_CODE_PATTERN = Pattern.compile("\"access_token\"[ ]*:[ ]*\"([^\\\"]*)\"");
    private static final Pattern REFRESH_TOKEN_PATTERN = Pattern.compile("\"refresh_token\"[ ]*:[ ]*\"([^\\\"]*)\"");
    private static final Pattern EXPIRATION_TIME_PATTERN = Pattern.compile("\"expires_in\"[ ]*:[ ]*([\\d]*)");
    private OAuthResponseParser parser = new DefaultOAuthResponseParser();

    @Test
    public void accessToken() {
        Assert.assertEquals((String)this.parser.extractAccessCode(ACCESS_CODE_PATTERN, response), (String)"ya29.AHES6ZTtm7SuokEB-RGtbBty9IIlNiP9-eNMMQKtXdMP3sfjL1Fc");
    }

    @Test(expected=IllegalArgumentException.class)
    public void noAccessToken() {
        this.parser.extractAccessCode(ACCESS_CODE_PATTERN, "i have no token for you");
    }

    @Test
    public void refreshToken() {
        Assert.assertEquals((String)this.parser.extractRefreshToken(REFRESH_TOKEN_PATTERN, response), (String)"1/HKSmLFXzqP0leUihZp2xUt3-5wkU7Gmu2Os_eBnzw74");
    }

    @Test
    public void noRefreshToken() {
        Assert.assertNull((Object)this.parser.extractRefreshToken(REFRESH_TOKEN_PATTERN, "no refresh token for you"));
    }

    @Test
    public void expirationTime() {
        Date now = new Date();
        Date expiration = this.parser.extractExpirationTime(EXPIRATION_TIME_PATTERN, response);
        Assert.assertTrue((expiration.getTime() - now.getTime() >= 3600000L ? 1 : 0) != 0);
    }

    @Test
    public void noExpirationTime() {
        Assert.assertNull((Object)this.parser.extractExpirationTime(EXPIRATION_TIME_PATTERN, "you're out of time"));
    }
}

