/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth.processor;

import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleEvent;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.processor.MessageProcessor;
import org.mule.security.oauth.DefaultHttpCallback;
import org.mule.security.oauth.callback.DefaultHttpCallbackAdapter;
import org.mule.security.oauth.callback.DefaultHttpCallbackFactory;
import org.mule.security.oauth.callback.HttpCallbackAdapter;
import org.mule.security.oauth.processor.FetchAccessTokenMessageProcessor;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.http.HttpConnector;

public class OAuthContinuationTestCase
extends AbstractMuleContextTestCase {
    @Rule
    public DynamicPort localPort = new DynamicPort("localPort");
    @Rule
    public DynamicPort remotePort = new DynamicPort("remotePort");
    private HttpConnector httpConnector;
    private DefaultHttpCallback callback;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.httpConnector = new HttpConnector(muleContext);
        this.httpConnector.initialise();
        this.httpConnector.start();
    }

    protected void doTearDown() throws Exception {
        if (this.callback != null) {
            this.callback.stop();
        }
        this.httpConnector.stop();
        this.httpConnector.dispose();
        super.doTearDown();
    }

    @Test
    public void verifyLifecycleOnlyExecutedOnce() throws Exception {
        MuleEvent event = OAuthContinuationTestCase.getTestEvent((Object)"authCode");
        DefaultHttpCallbackAdapter adapter = new DefaultHttpCallbackAdapter();
        adapter.setDomain("localhost");
        adapter.setLocalPort(Integer.valueOf(this.localPort.getNumber()));
        adapter.setRemotePort(Integer.valueOf(this.remotePort.getNumber()));
        adapter.setPath("/testCallback");
        adapter.setConnector((Object)this.httpConnector);
        FetchAccessTokenMessageProcessor fetchMessageProcessor = (FetchAccessTokenMessageProcessor)Mockito.mock(FetchAccessTokenMessageProcessor.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)fetchMessageProcessor.process((MuleEvent)Matchers.any(MuleEvent.class))).thenReturn((Object)event);
        MessageProcessor listener = (MessageProcessor)Mockito.mock(MessageProcessor.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Initialisable.class}));
        ((Initialisable)listener).initialise();
        FlowConstruct flowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        DefaultHttpCallbackFactory callbackFactory = new DefaultHttpCallbackFactory();
        this.callback = (DefaultHttpCallback)callbackFactory.createCallback((HttpCallbackAdapter)adapter, "(.)", fetchMessageProcessor, listener, muleContext, flowConstruct);
        this.callback.start();
        ((Initialisable)Mockito.verify((Object)((Initialisable)listener))).initialise();
        this.callback.getFlow().process(event);
        ((MessageProcessor)Mockito.verify((Object)listener)).process(event);
    }
}

