/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth.processor;

import java.lang.reflect.Type;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.security.oauth.OAuth2Adapter;
import org.mule.security.oauth.OAuth2Manager;
import org.mule.security.oauth.processor.BaseOAuth2UnauthorizeMessageProcessor;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class OAuth2UnauthorizeMessageProcessorTestCase {
    private static final String accessTokenId = "accessTokenId";
    private OAuth2Manager<OAuth2Adapter> manager;
    @Mock
    private OAuth2Adapter adapter;
    private MuleEvent event;
    private BaseOAuth2UnauthorizeMessageProcessor<OAuth2Manager<OAuth2Adapter>> processor;

    @Before
    public void setUp() {
        this.processor = new TestUnauthorizeMessageProcessor();
        this.processor.setAccessTokenId(accessTokenId);
        this.processor.setModuleObject(this.manager);
        this.manager = (OAuth2Manager)Mockito.mock(OAuth2Manager.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.event = (MuleEvent)Mockito.mock(MuleEvent.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.event.getMessage().getPayload()).thenReturn((Object)"");
    }

    @Test
    public void unathorize() throws Exception {
        Mockito.when((Object)this.manager.acquireAccessToken(accessTokenId)).thenReturn((Object)this.adapter);
        this.processor.process(this.event);
        ((OAuth2Manager)Mockito.verify(this.manager)).destroyAccessToken(accessTokenId, this.adapter);
    }

    @Test(expected=DefaultMuleException.class)
    public void unathorizeNotExistent() throws Exception {
        Mockito.when((Object)this.manager.acquireAccessToken(Mockito.anyString())).thenReturn(null);
        this.processor.process(this.event);
    }

    @Test
    public void idFromConfig() throws Exception {
        this.processor.setAccessTokenId(null);
        Mockito.when((Object)this.manager.getDefaultUnauthorizedConnector().getName()).thenReturn((Object)accessTokenId);
        this.unathorize();
    }

    private class TestUnauthorizeMessageProcessor
    extends BaseOAuth2UnauthorizeMessageProcessor<OAuth2Manager<OAuth2Adapter>> {
        private TestUnauthorizeMessageProcessor() {
        }

        protected Class<OAuth2Manager<OAuth2Adapter>> getOAuthManagerClass() {
            return null;
        }

        protected OAuth2Manager<OAuth2Adapter> getOAuthManager() {
            return OAuth2UnauthorizeMessageProcessorTestCase.this.manager;
        }

        protected Object evaluateAndTransform(MuleContext muleContext, MuleEvent event, Type expectedType, String expectedMimeType, Object source) throws TransformerException, TransformerMessagingException {
            return source != null ? source.toString() : null;
        }

        protected Object evaluateAndTransform(MuleContext muleContext, MuleMessage muleMessage, Type expectedType, String expectedMimeType, Object source) throws TransformerException, TransformerMessagingException {
            return source != null ? source.toString() : null;
        }
    }
}

