/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth.processor;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mule.RequestContext;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.store.ObjectDoesNotExistException;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.transport.PropertyScope;
import org.mule.module.http.internal.ParameterMap;
import org.mule.security.oauth.OAuth2Adapter;
import org.mule.security.oauth.OAuth2Manager;
import org.mule.security.oauth.processor.OAuth2FetchAccessTokenMessageProcessor;
import org.mule.security.oauth.processor.OAuthNotificationMatcher;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class OAuth2FetchAccessTokenProcessorTestCase {
    private static final String verifier = "verifier";
    private static final String eventId = UUID.randomUUID().toString();
    private String state;
    private String incomingState;
    private boolean exception;
    private OAuth2Manager<OAuth2Adapter> manager = null;
    private OAuth2FetchAccessTokenMessageProcessor processor;
    private MuleEvent event;
    private MuleEvent restoredEvent;
    private ParameterMap parameters = new ParameterMap();
    private ParameterMap restoredParameters = new ParameterMap();
    @Mock
    private MuleContext muleContext;

    @Before
    public void setUp() throws Exception {
        this.state = "my state";
        this.incomingState = String.format("<<MULE_EVENT_ID=%s>>%s", eventId, this.state);
        this.exception = false;
        this.restoredEvent = (MuleEvent)Mockito.mock(MuleEvent.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.restoredEvent.getMessage().getInboundProperty("http.query.params")).thenReturn((Object)this.restoredParameters);
        this.manager = (OAuth2Manager)Mockito.mock(OAuth2Manager.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.manager.restoreAuthorizationEvent(eventId)).thenReturn((Object)this.restoredEvent);
        this.processor = new OAuth2FetchAccessTokenMessageProcessor(this.manager, null);
        this.processor.setMuleContext(this.muleContext);
        this.event = (MuleEvent)Mockito.mock(MuleEvent.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.event.getMessage().getInvocationProperty("_oauthVerifier")).thenReturn((Object)verifier);
        this.parameters.put("state", this.incomingState);
        Mockito.when((Object)this.event.getMessage().getInboundProperty("http.query.params")).thenReturn((Object)this.parameters);
        Mockito.when((Object)this.restoredEvent.getMuleContext().getExpressionManager().parse(Matchers.anyString(), (MuleMessage)Matchers.any(MuleMessage.class))).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                return (String)invocation.getArguments()[0];
            }
        });
    }

    @After
    public void tearDown() throws Exception {
        if (!this.exception) {
            ((OAuth2Manager)Mockito.verify(this.manager)).restoreAuthorizationEvent(eventId);
            Assert.assertSame((Object)RequestContext.getEvent(), (Object)this.restoredEvent);
            ((MuleContext)Mockito.verify((Object)this.muleContext)).fireNotification((ServerNotification)Matchers.argThat((Matcher)new OAuthNotificationMatcher(400002, this.event)));
            ((MuleMessage)Mockito.verify((Object)this.restoredEvent.getMessage())).removeProperty("http.status", PropertyScope.OUTBOUND);
            ((MuleMessage)Mockito.verify((Object)this.restoredEvent.getMessage())).removeProperty("Location", PropertyScope.OUTBOUND);
        }
    }

    @Test
    public void stateRestored() throws Exception {
        final AtomicReference parameters = new AtomicReference();
        MuleMessage mockMessage = (MuleMessage)Mockito.mock(MuleMessage.class);
        Mockito.when((Object)this.restoredEvent.getMessage()).thenReturn((Object)mockMessage);
        Mockito.when((Object)mockMessage.getInboundProperty("http.query.params")).thenReturn((Object)this.restoredParameters);
        ((MuleMessage)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                if (invocationOnMock.getArguments()[0].equals("http.query.params")) {
                    parameters.set((HashMap)invocationOnMock.getArguments()[1]);
                }
                return null;
            }
        }).when((Object)mockMessage)).setProperty(Matchers.anyString(), Matchers.any(Map.class), (PropertyScope)Matchers.any(PropertyScope.class));
        this.adapterWithUrlUsingConfigAsId();
        Assert.assertThat(((HashMap)parameters.get()).get("state"), (Matcher)CoreMatchers.equalTo((Object)this.state));
    }

    @Test
    public void badState() throws Exception {
        this.incomingState = "bad state";
        this.exception = true;
        this.parameters.clear();
        this.parameters.put("state", this.incomingState);
        String accessTokenUrl = "accessTokenUrl";
        String redirectUri = "redirectUri";
        String accessTokenId = "accessTokenId";
        this.processor.setRedirectUri("redirectUri");
        OAuth2Adapter adapter = (OAuth2Adapter)Mockito.mock(OAuth2Adapter.class);
        Mockito.when((Object)this.manager.createAdapter(this.restoredEvent, verifier)).thenReturn((Object)adapter);
        Mockito.when((Object)this.manager.getDefaultUnauthorizedConnector().getName()).thenReturn((Object)"accessTokenId");
        Mockito.when((Object)adapter.getAccessTokenUrl()).thenReturn((Object)"accessTokenUrl");
        Assert.assertSame((Object)this.event, (Object)this.processor.process(this.event));
    }

    @Test(expected=MessagingException.class)
    public void noAuthorizationEvent() throws Exception {
        this.exception = true;
        Mockito.when((Object)this.manager.restoreAuthorizationEvent(eventId)).thenThrow(new Throwable[]{new ObjectDoesNotExistException()});
        this.adapterWithUrlUsingConfigAsId();
    }

    @Test(expected=MessagingException.class)
    public void failToRestoreAuthorizationEvent() throws Exception {
        this.exception = true;
        Mockito.when((Object)this.manager.restoreAuthorizationEvent(eventId)).thenThrow(new Throwable[]{new ObjectStoreException()});
        this.adapterWithUrlUsingConfigAsId();
    }

    @Test
    public void adapterWithUrlUsingConfigAsId() throws Exception {
        String accessTokenUrl = "accessTokenUrl";
        String redirectUri = "redirectUri";
        String accessTokenId = "accessTokenId";
        this.processor.setRedirectUri("redirectUri");
        OAuth2Adapter adapter = (OAuth2Adapter)Mockito.mock(OAuth2Adapter.class);
        Mockito.when((Object)this.manager.createAdapter(this.restoredEvent, verifier)).thenReturn((Object)adapter);
        Mockito.when((Object)this.manager.getDefaultUnauthorizedConnector().getName()).thenReturn((Object)"accessTokenId");
        Mockito.when((Object)adapter.getAccessTokenUrl()).thenReturn((Object)"accessTokenUrl");
        Assert.assertSame((Object)this.restoredEvent, (Object)this.processor.process(this.event));
        ((OAuth2Adapter)Mockito.verify((Object)adapter)).fetchAccessToken("redirectUri");
        ((KeyedPoolableObjectFactory)Mockito.verify((Object)this.manager.getAccessTokenPoolFactory())).passivateObject((Object)"accessTokenId", (Object)adapter);
        ((MuleMessage)Mockito.verify((Object)this.restoredEvent.getMessage())).setInvocationProperty("OAuthAccessTokenId", (Object)"accessTokenId");
    }

    @Test
    public void adapterWitouthUrlUsingConfigAsId() throws Exception {
        String accessTokenUrl = "accessTokenUrl";
        String redirectUri = "redirectUri";
        String accessTokenId = "accessTokenId";
        this.processor.setRedirectUri("redirectUri");
        this.processor.setAccessTokenUrl("accessTokenUrl");
        OAuth2Adapter adapter = (OAuth2Adapter)Mockito.mock(OAuth2Adapter.class);
        Mockito.when((Object)this.manager.createAdapter(this.restoredEvent, verifier)).thenReturn((Object)adapter);
        Mockito.when((Object)this.manager.getDefaultUnauthorizedConnector().getName()).thenReturn((Object)"accessTokenId");
        Assert.assertSame((Object)this.restoredEvent, (Object)this.processor.process(this.event));
        ((OAuth2Adapter)Mockito.verify((Object)adapter)).fetchAccessToken("redirectUri");
        ((KeyedPoolableObjectFactory)Mockito.verify((Object)this.manager.getAccessTokenPoolFactory())).passivateObject((Object)"accessTokenId", (Object)adapter);
        ((MuleMessage)Mockito.verify((Object)this.restoredEvent.getMessage())).setInvocationProperty("OAuthAccessTokenId", (Object)"accessTokenId");
    }

    @Test
    public void adapterWithUrlUsingCustomId() throws Exception {
        String accessTokenUrl = "accessTokenUrl";
        String redirectUri = "redirectUri";
        String accessTokenId = "accessTokenId";
        this.processor.setRedirectUri("redirectUri");
        this.processor.setAccessTokenId("accessTokenId");
        OAuth2Adapter adapter = (OAuth2Adapter)Mockito.mock(OAuth2Adapter.class);
        Mockito.when((Object)this.manager.createAdapter(this.restoredEvent, verifier)).thenReturn((Object)adapter);
        Mockito.when((Object)adapter.getAccessTokenUrl()).thenReturn((Object)"accessTokenUrl");
        Assert.assertSame((Object)this.restoredEvent, (Object)this.processor.process(this.event));
        ((OAuth2Adapter)Mockito.verify((Object)adapter)).fetchAccessToken("redirectUri");
        ((KeyedPoolableObjectFactory)Mockito.verify((Object)this.manager.getAccessTokenPoolFactory())).passivateObject((Object)"accessTokenId", (Object)adapter);
        ((MuleMessage)Mockito.verify((Object)this.restoredEvent.getMessage())).setInvocationProperty("OAuthAccessTokenId", (Object)"accessTokenId");
    }

    @Test
    public void adapterWitouthUrlUsingCustomId() throws Exception {
        String accessTokenUrl = "accessTokenUrl";
        String redirectUri = "redirectUri";
        String accessTokenId = "accessTokenId";
        this.processor.setRedirectUri("redirectUri");
        this.processor.setAccessTokenUrl("accessTokenUrl");
        this.processor.setAccessTokenId("accessTokenId");
        OAuth2Adapter adapter = (OAuth2Adapter)Mockito.mock(OAuth2Adapter.class);
        Mockito.when((Object)this.manager.createAdapter(this.restoredEvent, verifier)).thenReturn((Object)adapter);
        Assert.assertSame((Object)this.restoredEvent, (Object)this.processor.process(this.event));
        ((OAuth2Adapter)Mockito.verify((Object)adapter)).fetchAccessToken("redirectUri");
        ((KeyedPoolableObjectFactory)Mockito.verify((Object)this.manager.getAccessTokenPoolFactory())).passivateObject((Object)"accessTokenId", (Object)adapter);
        ((MuleMessage)Mockito.verify((Object)this.restoredEvent.getMessage())).setInvocationProperty("OAuthAccessTokenId", (Object)"accessTokenId");
    }
}

