/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth.processor;

import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.callback.HttpCallback;
import org.mule.api.callback.HttpCallbackFactory;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.common.security.oauth.AuthorizationParameter;
import org.mule.security.oauth.OAuth2Adapter;
import org.mule.security.oauth.OAuth2Manager;
import org.mule.security.oauth.callback.HttpCallbackAdapter;
import org.mule.security.oauth.processor.BaseOAuth2AuthorizeMessageProcessor;
import org.mule.security.oauth.processor.FetchAccessTokenMessageProcessor;
import org.mule.security.oauth.processor.OAuthNotificationMatcher;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class OAuth2AuthorizeMessageProcessorTestCase {
    private static final String eventId = "eventId";
    private OAuth2Manager<OAuth2Adapter> manager;
    private TestAuthorizeMessageProcessor processor;
    private MuleEvent event;
    @Mock
    private MuleContext muleContext;
    private HttpCallbackFactory callbackFactory;

    @Before
    public void setUp() throws Exception {
        this.manager = (OAuth2Manager)Mockito.mock(OAuth2Manager.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.event = (MuleEvent)Mockito.mock(MuleEvent.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.event.getId()).thenReturn((Object)eventId);
        HttpCallback callback = this.initCallbackFactoryMock();
        Mockito.when((Object)callback.getUrl()).thenReturn((Object)"url");
        this.processor = new TestAuthorizeMessageProcessor();
        this.processor.setCallbackFactory(this.callbackFactory);
        this.processor.setModuleObject(this.manager);
        this.processor.setMuleContext(this.muleContext);
        this.processor.start();
    }

    private HttpCallback initCallbackFactoryMock() throws MuleException {
        this.callbackFactory = (HttpCallbackFactory)Mockito.mock(HttpCallbackFactory.class);
        HttpCallback callback = (HttpCallback)Mockito.mock(HttpCallback.class);
        Mockito.when((Object)this.callbackFactory.createCallback((HttpCallbackAdapter)Mockito.any(HttpCallbackAdapter.class), (String)Mockito.any(String.class), (FetchAccessTokenMessageProcessor)Mockito.any(FetchAccessTokenMessageProcessor.class), (MessageProcessor)Mockito.any(MessageProcessor.class), (MuleContext)Mockito.any(MuleContext.class), (FlowConstruct)Mockito.any(FlowConstruct.class))).thenReturn((Object)callback);
        return callback;
    }

    @Test
    public void getOAuthManager() {
        Assert.assertSame(this.manager, (Object)this.processor.getOAuthManager());
    }

    @Test
    public void process() throws Exception {
        this.doProcess("state");
    }

    @Test
    public void processWithoutState() throws Exception {
        this.doProcess("");
    }

    @Test
    public void processWithDefaultAccessTokenId() throws Exception {
        String defaultAccessTokenId = "default";
        Mockito.when((Object)this.manager.getDefaultAccessTokenId()).thenReturn((Object)"default");
        this.assertAccessTokenId("default");
    }

    @Test
    public void processWithProcessorLevelAccessTokenId() throws Exception {
        String accessTokenId = "processor";
        this.processor.setAccessTokenId("processor");
        this.assertAccessTokenId("processor");
    }

    @Test
    public void processWithConfiNameAsTokenId() throws Exception {
        String accessTokenId = "name";
        Mockito.when((Object)this.manager.getDefaultUnauthorizedConnector().getName()).thenReturn((Object)"name");
        this.assertAccessTokenId("name");
    }

    private void assertAccessTokenId(String accessTokenId) throws Exception {
        this.initCallbackFactoryMock();
        this.processor.setOauthCallback(null);
        this.processor.setCallbackFactory(this.callbackFactory);
        this.processor.start();
        this.doProcess("");
        ArgumentCaptor captor = ArgumentCaptor.forClass(FetchAccessTokenMessageProcessor.class);
        ((HttpCallbackFactory)Mockito.verify((Object)this.callbackFactory)).createCallback((HttpCallbackAdapter)Mockito.any(OAuth2Manager.class), Mockito.anyString(), (FetchAccessTokenMessageProcessor)captor.capture(), (MessageProcessor)Mockito.any(MessageProcessor.class), (MuleContext)Mockito.any(MuleContext.class), (FlowConstruct)Mockito.any(FlowConstruct.class));
        FetchAccessTokenMessageProcessor processor = (FetchAccessTokenMessageProcessor)captor.getValue();
        Assert.assertEquals((String)processor.getAccessTokenId(), (String)accessTokenId);
    }

    private void doProcess(final String state) throws Exception {
        String authorizeUrl = "authorizeUrl";
        String customField = "customField";
        String anotherCustomField = "anotherCustomField";
        this.processor.setState(state);
        this.processor.setCustomField("customField");
        this.processor.setAnotherCustomField("anotherCustomField");
        Mockito.when((Object)this.manager.getDefaultUnauthorizedConnector().getAuthorizationParameters()).thenReturn(this.getAuthorizePropertiesWithoutDefaults());
        Mockito.when((Object)this.manager.buildAuthorizeUrl(Mockito.anyMap(), Mockito.anyString(), Mockito.anyString())).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                Map parameters = (Map)invocation.getArguments()[0];
                String expectedState = String.format("<<MULE_EVENT_ID=%s>>", OAuth2AuthorizeMessageProcessorTestCase.eventId) + state;
                Assert.assertEquals((String)expectedState, (String)URLDecoder.decode((String)parameters.get("state"), "UTF-8"));
                Assert.assertEquals((String)"customField".toLowerCase(), (String)((String)parameters.get("customField")));
                Assert.assertEquals((String)"anotherCustomField".toLowerCase(), (String)((String)parameters.get("anotherCustomField")));
                return "authorizeUrl";
            }
        });
        this.processor.process(this.event);
        ((OAuth2Manager)Mockito.verify(this.manager)).storeAuthorizationEvent(this.event);
        ((MuleMessage)Mockito.verify((Object)this.event.getMessage())).setOutboundProperty("http.status", (Object)"302");
        ((MuleMessage)Mockito.verify((Object)this.event.getMessage())).setOutboundProperty("Location", (Object)"authorizeUrl");
        ((MuleContext)Mockito.verify((Object)this.muleContext)).fireNotification((ServerNotification)Mockito.argThat((Matcher)new OAuthNotificationMatcher(400001, this.event)));
    }

    private Set<AuthorizationParameter<?>> getAuthorizePropertiesWithoutDefaults() {
        LinkedHashSet parameters = new LinkedHashSet();
        parameters.add(new AuthorizationParameter("customField", "A custom field", false, null, String.class));
        parameters.add(new AuthorizationParameter("anotherCustomField", "anotherCustomField", false, null, String.class));
        return parameters;
    }

    private class TestAuthorizeMessageProcessor
    extends BaseOAuth2AuthorizeMessageProcessor<OAuth2Manager<OAuth2Adapter>> {
        private String customField;
        private String anotherCustomField;

        private TestAuthorizeMessageProcessor() {
        }

        protected String getAuthCodeRegex() {
            return "\"access_token\"[ ]*:[ ]*\"([^\\\"]*)\"";
        }

        protected Class<OAuth2Manager<OAuth2Adapter>> getOAuthManagerClass() {
            return null;
        }

        protected Object evaluateAndTransform(MuleContext muleContext, MuleEvent event, Type expectedType, String expectedMimeType, Object source) throws TransformerException, TransformerMessagingException {
            return source != null ? source.toString() : null;
        }

        protected Object evaluateAndTransform(MuleContext muleContext, MuleMessage muleMessage, Type expectedType, String expectedMimeType, Object source) throws TransformerException, TransformerMessagingException {
            return source != null ? source.toString() : null;
        }

        public String getCustomField() {
            return this.customField;
        }

        public void setCustomField(String customField) {
            this.customField = customField;
        }

        public String getAnotherCustomField() {
            return this.anotherCustomField;
        }

        public void setAnotherCustomField(String anotherCustomField) {
            this.anotherCustomField = anotherCustomField;
        }
    }
}

