/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth.processor;

import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.context.notification.ServerNotification;
import org.mule.security.oauth.OAuth1Adapter;
import org.mule.security.oauth.processor.OAuth1FetchAccessTokenMessageProcessor;
import org.mule.security.oauth.processor.OAuthNotificationMatcher;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class OAuth1FetchAccessTokenProcessorTestCase {
    private static final String accessTokenUrl = "accessTokenUrl";
    private static final String redirectUri = "redirectUri";
    private static final String requestTokenUrl = "requestTokenUrl";
    private static final String authorizationUrl = "authorizationUrl";
    @Mock
    private OAuth1Adapter adapter;
    @Mock
    private MuleContext muleContext;
    private MuleEvent event;
    private OAuth1FetchAccessTokenMessageProcessor processor;

    @Before
    public void setUp() {
        this.event = (MuleEvent)Mockito.mock(MuleEvent.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.processor = new OAuth1FetchAccessTokenMessageProcessor(this.adapter);
        this.processor.setAccessTokenUrl(accessTokenUrl);
        this.processor.setRedirectUri(redirectUri);
        this.processor.setAuthorizationUrl(authorizationUrl);
        this.processor.setRequestTokenUrl(requestTokenUrl);
        this.processor.setMuleContext(this.muleContext);
    }

    @Test
    public void process() throws Exception {
        String verifier = "my verifier";
        Mockito.when((Object)this.event.getMessage().getInvocationProperty("_oauthVerifier")).thenReturn((Object)"my verifier");
        this.processor.process(this.event);
        ((OAuth1Adapter)Mockito.verify((Object)this.adapter)).fetchAccessToken(requestTokenUrl, accessTokenUrl, authorizationUrl, redirectUri);
        ((OAuth1Adapter)Mockito.verify((Object)this.adapter)).setOauthVerifier("my verifier");
        ((MuleContext)Mockito.verify((Object)this.muleContext)).fireNotification((ServerNotification)Mockito.argThat((Matcher)new OAuthNotificationMatcher(400002, this.event)));
    }
}

