/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth.processor;

import java.lang.reflect.Type;
import java.util.Map;
import junit.framework.Assert;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.callback.HttpCallback;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.security.oauth.OAuth1Adapter;
import org.mule.security.oauth.processor.BaseOAuth1AuthorizeMessageProcessor;
import org.mule.security.oauth.processor.OAuthNotificationMatcher;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class OAuth1AuthorizeMessageProcessorTestCase {
    private static final String redirectUri = "redirectUri";
    @Mock
    private OAuth1Adapter adapter;
    private TestAuthorizeMessageProcessor processor;
    private MuleEvent event;
    @Mock
    private MuleContext muleContext;

    @Before
    public void setUp() {
        this.event = (MuleEvent)Mockito.mock(MuleEvent.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        HttpCallback callback = (HttpCallback)Mockito.mock(HttpCallback.class);
        Mockito.when((Object)callback.getUrl()).thenReturn((Object)redirectUri);
        this.processor = new TestAuthorizeMessageProcessor();
        this.processor.setOauthCallback(callback);
        this.processor.setModuleObject(this.adapter);
        this.processor.setMuleContext(this.muleContext);
    }

    @Test
    public void getAdapter() {
        Assert.assertSame((Object)this.adapter, (Object)this.processor.getAdapter());
    }

    @Test
    public void process() throws Exception {
        String state = "state";
        String authorizeUrl = "authorizeUrl";
        String accessTokenUrl = "accessTokenUrl";
        String requestTokenUrl = "requestTokenUrl";
        String location = "location";
        this.processor.setState("state");
        this.processor.setAuthorizationUrl("authorizeUrl");
        this.processor.setAccessTokenUrl("accessTokenUrl");
        this.processor.setRequestTokenUrl("requestTokenUrl");
        Mockito.when((Object)this.adapter.authorize((Map)Mockito.argThat((Matcher)new BaseMatcher<Map<String, String>>(){

            public boolean matches(Object item) {
                Map map = (Map)item;
                return "state".equals(map.get("state"));
            }

            public void describeTo(Description description) {
                description.appendText("map matcher and asserter");
            }
        }), (String)Mockito.eq((Object)"requestTokenUrl"), (String)Mockito.eq((Object)"accessTokenUrl"), (String)Mockito.eq((Object)"authorizeUrl"), (String)Mockito.eq((Object)redirectUri))).thenReturn((Object)"location");
        this.processor.process(this.event);
        ((OAuth1Adapter)Mockito.verify((Object)this.adapter)).setAccessTokenUrl("accessTokenUrl");
        ((MuleMessage)Mockito.verify((Object)this.event.getMessage())).setOutboundProperty("http.status", (Object)"302");
        ((MuleMessage)Mockito.verify((Object)this.event.getMessage())).setOutboundProperty("Location", (Object)"location");
        ((MuleContext)Mockito.verify((Object)this.muleContext)).fireNotification((ServerNotification)Mockito.argThat((Matcher)new OAuthNotificationMatcher(400001, this.event)));
    }

    private class TestAuthorizeMessageProcessor
    extends BaseOAuth1AuthorizeMessageProcessor {
        private TestAuthorizeMessageProcessor() {
        }

        protected Class<? extends OAuth1Adapter> getAdapterClass() {
            return null;
        }

        protected OAuth1Adapter getAdapter() {
            return super.getAdapter();
        }

        protected String getAuthCodeRegex() {
            return "\"access_token\"[ ]*:[ ]*\"([^\\\"]*)\"";
        }

        protected Object evaluateAndTransform(MuleContext muleContext, MuleEvent event, Type expectedType, String expectedMimeType, Object source) throws TransformerException, TransformerMessagingException {
            return source != null ? source.toString() : null;
        }

        protected Object evaluateAndTransform(MuleContext muleContext, MuleMessage muleMessage, Type expectedType, String expectedMimeType, Object source) throws TransformerException, TransformerMessagingException {
            return source != null ? source.toString() : null;
        }
    }
}

