/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth.processor;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.processor.MessageProcessor;
import org.mule.common.security.oauth.exception.NotAuthorizedException;
import org.mule.devkit.processor.DevkitBasedMessageProcessor;
import org.mule.security.oauth.OAuthAdapter;
import org.mule.security.oauth.OnNoTokenPolicy;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class DevkitBasedProcessorTestCase {
    private DevkitBasedMessageProcessor processor;
    @Mock
    private Object testStrategy;
    @Mock
    private OAuthAdapter adapter;
    private MuleEvent event;

    @Before
    public void setUp() {
        this.processor = new TestProcessor();
        this.processor.setModuleObject((Object)this.adapter);
        this.event = (MuleEvent)Mockito.mock(MuleEvent.class);
    }

    @Test(expected=MessagingException.class)
    public void unauthorizedException() throws Exception {
        Mockito.when((Object)this.testStrategy.toString()).thenThrow(new Class[]{NotAuthorizedException.class});
        Mockito.when((Object)this.adapter.getOnNoTokenPolicy()).thenReturn((Object)OnNoTokenPolicy.EXCEPTION);
        try {
            this.processor.process(this.event);
        }
        catch (MessagingException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof NotAuthorizedException));
            throw e;
        }
    }

    @Test
    public void unauthorizedStopChain() throws Exception {
        Mockito.when((Object)this.testStrategy.toString()).thenThrow(new Class[]{NotAuthorizedException.class});
        Mockito.when((Object)this.adapter.getOnNoTokenPolicy()).thenReturn((Object)OnNoTokenPolicy.STOP_FLOW);
        Assert.assertNull((Object)this.processor.process(this.event));
    }

    private class TestProcessor
    extends DevkitBasedMessageProcessor
    implements MessageProcessor {
        private TestProcessor() {
            super("test");
        }

        protected MuleEvent doProcess(MuleEvent event) throws Exception {
            DevkitBasedProcessorTestCase.this.testStrategy.toString();
            return event;
        }
    }
}

