/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth.processor;

import java.util.Arrays;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.callback.HttpCallback;
import org.mule.api.processor.MessageProcessor;
import org.mule.module.http.api.listener.HttpListenerConfig;
import org.mule.module.http.internal.listener.DefaultHttpListenerConfig;
import org.mule.security.oauth.DefaultHttpCallback;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.http.HttpConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultHttpCallbackTestCase
extends AbstractMuleContextTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHttpCallbackTestCase.class);
    private static final String CALLBACK_PATH = "callback";
    private static final String CONNECTOR_HTTP_MULE_DEFAULT = "connector.http.mule.default";
    @Rule
    public DynamicPort localPort = new DynamicPort("localPort");
    @Rule
    public DynamicPort remotePort = new DynamicPort("remotePort");
    @Mock
    private MessageProcessor processor;
    private HttpClient httpClient;
    private GetMethod callbackMethod;
    private HttpCallback callback;

    protected void doSetUp() throws Exception {
        this.httpClient = new HttpClient();
        this.callbackMethod = new GetMethod(this.buildCallbackUrl());
        Mockito.when((Object)this.processor.process((MuleEvent)org.mockito.Matchers.any(MuleEvent.class))).thenAnswer((Answer)new Answer<MuleEvent>(){

            public MuleEvent answer(InvocationOnMock invocationOnMock) throws Throwable {
                return (MuleEvent)invocationOnMock.getArguments()[0];
            }
        });
    }

    protected void doTearDown() throws Exception {
        if (this.callbackMethod != null) {
            try {
                this.callbackMethod.releaseConnection();
            }
            catch (Exception e) {
                this.handleExceptionWhileTearingDown(e);
            }
        }
        if (this.callback != null) {
            try {
                this.callback.stop();
            }
            catch (Exception e) {
                this.handleExceptionWhileTearingDown(e);
            }
        }
    }

    @Test
    public void withNewHttpConnector() throws Exception {
        HttpListenerConfig config = this.createListenerConfig();
        this.callback = this.createCallback(config);
        this.sendCallbackRequest();
    }

    @Test
    public void withOldHttpTransport() throws Exception {
        this.callback = this.createCallback(this.newOldHttpTransport());
        this.sendCallbackRequest();
    }

    @Test
    public void withNewHttpConnectorByDefault() throws Exception {
        this.createListenerConfig();
        this.callback = this.createCallback(null);
        this.sendCallbackRequest();
    }

    private HttpListenerConfig createListenerConfig() throws MuleException {
        DefaultHttpListenerConfig listenerConfig = new DefaultHttpListenerConfig();
        listenerConfig.setPort(this.localPort.getNumber());
        listenerConfig.setHost("localhost");
        listenerConfig.setMuleContext(muleContext);
        muleContext.getRegistry().registerObject("callbackConfig", (Object)listenerConfig);
        listenerConfig.start();
        return listenerConfig;
    }

    @Test
    public void withNewHttpConnectorByDefaultAndNoListenerConfigured() throws Exception {
        this.callback = this.createCallback(null);
        this.sendCallbackRequest();
    }

    @Test
    public void withOldHttpTransportByDefault() throws Exception {
        MuleTestUtils.testWithSystemProperty((String)"mule.http.useTransportForUris", (String)Boolean.TRUE.toString(), (MuleTestUtils.TestCallback)new MuleTestUtils.TestCallback(){

            public void run() throws Exception {
                DefaultHttpCallbackTestCase.this.newOldHttpTransport();
                DefaultHttpCallbackTestCase.this.callback = DefaultHttpCallbackTestCase.this.createCallback(null);
                DefaultHttpCallbackTestCase.this.sendCallbackRequest();
            }
        });
    }

    private void sendCallbackRequest() throws Exception {
        int response = this.httpClient.executeMethod((HttpMethod)this.callbackMethod);
        Assert.assertThat((Object)response, (Matcher)Matchers.is((Object)200));
        ((MessageProcessor)Mockito.verify((Object)this.processor)).process((MuleEvent)org.mockito.Matchers.any(MuleEvent.class));
    }

    private HttpCallback createCallback(Object connector) throws MuleException {
        DefaultHttpCallback callback = new DefaultHttpCallback(Arrays.asList(this.processor), muleContext, "localhost", Integer.valueOf(this.localPort.getNumber()), Integer.valueOf(this.remotePort.getNumber()), CALLBACK_PATH, Boolean.valueOf(false), connector);
        callback.start();
        return callback;
    }

    private HttpConnector newOldHttpTransport() throws Exception {
        HttpConnector httpConnector = new HttpConnector(muleContext);
        httpConnector.initialise();
        httpConnector.start();
        muleContext.getRegistry().registerObject(CONNECTOR_HTTP_MULE_DEFAULT, (Object)httpConnector);
        return httpConnector;
    }

    private void handleExceptionWhileTearingDown(Throwable t) {
        LOGGER.error("Found exception at tear down", t);
    }

    private String buildCallbackUrl() {
        return String.format("http://localhost:%d/%s", this.localPort.getNumber(), CALLBACK_PATH);
    }
}

